library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity ECPM_projective_to_affine is

    port( K : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x, y : out std_logic_vector( 255 downto 0));

 end entity;

 architecture behavioural of ECPM_projective_to_affine is

signal  done_ecpm, done_inv, done_mult1, done_mult2, shift : std_logic;
signal  Qx,Qy,Qz,z_inv : std_logic_vector (255 downto 0); 


 component ECPM_RADIX4 is
    port( K : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          Qx, Qy, Qz : out std_logic_vector( 255 downto 0));
 end component;

 component modular_inverter is
    port( B : in std_logic_vector(255 downto 0);
          clock, reset, start: in std_logic;          --reset active high 
          inv_out : out std_logic_vector(255 downto 0);
          done : out std_logic);
 end component;

 component modular_mult_RADIX4_precomp is
    port( A,B : in std_logic_vector(255 downto 0);
          clock, reset, start, shift : in std_logic;          --reset active high 
          mult_out : out std_logic_vector(255 downto 0);
          done : out std_logic); 
 end component;

 component flip_flop is
     port ( data_in : in std_logic;
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic);
 end component;

  begin

ecpm: ECPM_RADIX4 port map (K, clock, reset, start, done_ecpm, Qx, Qy, Qz);

inv: modular_inverter port map ( Qz, clock, reset, done_ecpm, z_inv, done_inv);

ff : flip_flop port map ('1', clock, done_inv, reset, shift);

mult1 : modular_mult_RADIX4_precomp port map (Qx, z_inv, clock, reset, done_inv, shift, x, done_mult1);

mult2 : modular_mult_RADIX4_precomp port map (Qy, z_inv, clock, reset, done_inv, shift, y, done_mult2);

done <= done_mult1 and done_mult2;

 end architecture;
