library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity ECPM_RADIX4 is

    port( K : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          Qx, Qy, Qz : out std_logic_vector( 255 downto 0));

 end entity;

 architecture behavioural of ECPM_RADIX4 is

signal  load_R0, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, regQ_load, reset_Q, reg2_load,
          reg1_reset, reg2_reset, start_PA, reset_PA, start_PD, reset_PD, cnt_reset, cnt_en :  std_logic;
signal  done_L, reg2_out, done_ecpm, mux0_out :  std_logic;
signal  count : std_logic_vector (7 downto 0); 


 component ECPM_RADIX4_datapath is

    port( K : in std_logic_vector(255 downto 0);
          clock, start, reset : in std_logic;
          Qx, Qy, Qz : out std_logic_vector (255 downto 0);
          load_R0, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, regQ_load, reset_Q, reg2_load,
          reg1_reset, reg2_reset, start_PA, reset_PA, start_PD, reset_PD, cnt_reset, cnt_en : in std_logic;
          done_L, reg2_out: out std_logic;
          mux0_out : buffer std_logic;
          count : buffer std_logic_vector (7 downto 0)); 

 end component;

component ECPM_RADIX4_fsm is

port(     clock, start, reset : in std_logic; --reset acrive high
          done_ecpm : out std_logic;
          load_R0, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, regQ_load, reset_Q, reg2_load,
          reg1_reset, reg2_reset, start_PA, reset_PA, start_PD, reset_PD, cnt_reset, cnt_en : out std_logic;
          done_L, reg2_out: in std_logic;
          mux0_out : in std_logic;
          count : in std_logic_vector (7 downto 0)); 

end component;
  begin

datapath : ECPM_RADIX4_datapath port map ( K, clock, start, reset, Qx, Qy, Qz, load_R0, mux1_sel, mux2_sel,
           mux3_sel, mux4_sel, mux5_sel, regQ_load, reset_Q, reg2_load, reg1_reset, reg2_reset, start_PA,
           reset_PA, start_PD, reset_PD, cnt_reset, cnt_en, done_L, reg2_out, mux0_out, count);

fsm : ECPM_RADIX4_fsm port map (clock, start, reset, done_ecpm, load_R0, mux1_sel, mux2_sel, mux3_sel,
          mux4_sel, mux5_sel, regQ_load, reset_Q, reg2_load, reg1_reset, reg2_reset, start_PA, reset_PA,
          start_PD, reset_PD, cnt_reset, cnt_en, done_L, reg2_out, mux0_out, count);

done <= done_ecpm;

 end architecture;
