library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity ECPM_RADIX2_fsm is

port(     clock, start, reset : in std_logic; --reset acrive high
          done_ecpm : out std_logic;
          load_R0, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, regQ_load, reset_Q, reg2_load,
          reg1_reset, reg2_reset, start_PA, reset_PA, start_PD, reset_PD, cnt_reset, cnt_en : out std_logic;
          done_L, reg2_out: in std_logic;
          mux0_out : in std_logic;
          count : in std_logic_vector (7 downto 0)); 

end entity;

architecture structural of ECPM_RADIX2_fsm is

-------machine state----------
type state_type is (IDLE, SET_A, SET_B, A, B_A, B_B, B_C, B_D, C, D_A, D_B, DONE); --stati
signal present_state, next_state: state_type; --stato corrente, stato futuro

--..............................................SIGNAL.......................................................

--there are no signal because there is only the fsm and there is not the datapath inside this block

--.............................................COMPONENT.....................................................

--there are no component because there is only the fsm and there is not the datapath inside this block

--.................................................FSM........................................................
 begin

------------state update-------------
update_state: process(clock, reset)
begin

 if reset='1' then present_state <= IDLE;  --reset active high
 elsif (clock'event and clock='1') then present_state <= next_state;
 end if;

end process;

---------state transition------------
state_transition: process(clock, present_state)
begin
case present_state is

 when IDLE => if start = '1' and mux0_out = '1' then next_state <= SET_A;
              elsif start ='1' and mux0_out ='0' then  next_state <= SET_B;
              elsif start ='0' then next_state <= IDLE; end if;
 when SET_A => next_state <= A;
 when SET_B => next_state <= A;
  
 when A => if done_L = '1' and mux0_out = '1' and reg2_out ='1' then next_state <= B_A;
           elsif done_L = '1' and mux0_out = '1' and reg2_out ='0' then next_state <= B_B;
           elsif done_L = '1' and mux0_out = '0' and reg2_out ='1' then next_state <= B_C;
           elsif done_L = '1' and mux0_out = '0' and reg2_out ='0' then next_state <= B_D;
           elsif done_L = '0' then next_state <= A ; end if;

 when B_A => next_state <= C;
 when B_B => next_state <= C;
 when B_C => next_state <= C;
 when B_D => next_state <= C;

 when C => if done_L = '1' and count /= "00000000" and mux0_out = '1' and reg2_out ='1' then next_state <= B_A;
           elsif done_L = '1' and count /= "00000000" and mux0_out = '1' and reg2_out ='0' then next_state <= B_B;
           elsif done_L = '1' and count /= "00000000" and mux0_out = '0' and reg2_out ='1' then next_state <= B_C;
           elsif done_L = '1' and count /= "00000000" and mux0_out = '0' and reg2_out ='0' then next_state <= B_D;
           elsif done_L = '1' and count = "00000000" and reg2_out = '1' then next_state <= D_A;
           elsif done_L = '1' and count = "00000000" and reg2_out = '0' then next_state <= D_B;
           elsif done_L = '0' then next_state <= C; end if;
 
 when D_A => next_state <= DONE;
 when D_B => next_state <= DONE;
 when DONE => next_state <= IDLE; 

end case;
end process;

---------------output-------------
output: process(present_state)
begin
 
--default value signal control
done_ecpm <= '0'; load_R0 <= '0'; mux1_sel <= '0'; mux2_sel <= '0'; mux3_sel <= '0'; mux4_sel <= '0'; mux5_sel <= '0'; regQ_load <= '0'; reset_Q <= '0';
 reg2_load <= '0'; reg1_reset <= '0'; reg2_reset <= '0'; start_PA <= '0'; reset_PA <= '0'; start_PD <= '0'; reset_PD <= '0'; cnt_reset <= '0'; cnt_en <= '0';

case present_state is

 when IDLE => load_R0 <= '1'; cnt_reset <= '1'; reg1_reset <= '1'; reg2_reset <= '1'; reset_PA <= '1'; reset_PD <= '1'; reset_Q <= '1';

 when SET_A =>  mux1_sel <= '0'; mux2_sel <= '0'; mux3_sel <= '1'; mux4_sel <= '0'; mux5_sel <= '0';reg2_load <= '1'; start_PA <= '1'; start_PD <= '1'; cnt_en <= '1';
 when SET_B =>  mux1_sel <= '0'; mux2_sel <= '0'; mux3_sel <= '0'; mux4_sel <= '0'; mux5_sel <= '0';reg2_load <= '1'; start_PA <= '1'; start_PD <= '1'; cnt_en <= '1';

 when A => done_ECPM <= '0';

 when B_A =>   mux1_sel <= '1'; mux2_sel <= '1'; mux3_sel <= '1'; mux4_sel <= '1'; mux5_sel <= '1'; reg2_load <= '1'; start_PA <= '1'; start_PD <= '1'; cnt_en <= '1';
 when B_B =>   mux1_sel <= '1'; mux2_sel <= '1'; mux3_sel <= '1'; mux4_sel <= '0'; mux5_sel <= '0'; reg2_load <= '1'; start_PA <= '1'; start_PD <= '1'; cnt_en <= '1';
 when B_C =>   mux1_sel <= '1'; mux2_sel <= '1'; mux3_sel <= '0'; mux4_sel <= '1'; mux5_sel <= '1'; reg2_load <= '1'; start_PA <= '1'; start_PD <= '1'; cnt_en <= '1';
 when B_D =>   mux1_sel <= '1'; mux2_sel <= '1'; mux3_sel <= '0'; mux4_sel <= '0'; mux5_sel <= '0'; reg2_load <= '1'; start_PA <= '1'; start_PD <= '1'; cnt_en <= '1';

 when C => done_ECPM <= '0';

 when D_A =>   mux4_sel <= '1'; mux5_sel <= '1'; reg1_reset <= '1'; regQ_load <= '1';
 when D_B =>   mux4_sel <= '0'; mux5_sel <= '0'; reg1_reset <= '1'; regQ_load <= '1';

 when DONE => done_ecpm <= '1';


end case;
end process;
 
--..............................................DATAPATH.......................................................

--there are no datapath connection because there is only the fsm and there is not the datapath inside this block
      
                  
end architecture;
