library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.curve_parameter_pkg.all;

 entity ECPM_RADIX2_datapath is

    port( K : in std_logic_vector(255 downto 0);
          clock, start, reset : in std_logic;
          Qx, Qy, Qz : out std_logic_vector (255 downto 0);
          load_R0, mux1_sel, mux2_sel, mux3_sel, mux4_sel, mux5_sel, regQ_load, reset_Q, reg2_load,
          reg1_reset, reg2_reset, start_PA, reset_PA, start_PD, reset_PD, cnt_reset, cnt_en : in std_logic;
          done_L, reg2_out: out std_logic;
          mux0_out : buffer std_logic;
          count : buffer std_logic_vector (7 downto 0)); 

 end entity;

 architecture behavioural of ECPM_RADIX2_datapath is

signal  R0_out, mux1_x_out, mux1_y_out, mux1_z_out, mux2_x_out, mux2_y_out, mux2_z_out,  mux3_x_out, mux3_y_out, mux3_z_out : std_logic_vector(255 downto 0);
signal  mux4_x_out, mux4_y_out, mux4_z_out, mux5_x_out, mux5_y_out, mux5_z_out : std_logic_vector(255 downto 0);
signal  PA_x, PA_y, PA_z, PD_x, PD_y, PD_z, PD1_x, PD1_y, PD1_z, reg4_x_out, reg4_y_out, reg4_z_out : std_logic_vector(255 downto 0);
signal  mux0_sel :  std_logic_vector(7 downto 0);

signal done_PA, done_PD, reg1_out : std_logic;




 component mux2to1 is
    generic(n : integer);
    port( in_0, In_1 : in std_logic_vector (n-1 downto 0);
          sel: in std_logic;
          data_out : out std_logic_vector (n-1 downto 0));
 end component;

component Mux256to1 is
    Port (Selector : in  std_logic_vector(7 downto 0);
          Inputs   : in  std_logic_vector(255 downto 0);
          Output   : out std_logic);         
end component;

 component reg is
     generic( n: integer);
     port ( data_in : in std_logic_vector( n-1 downto 0);
            clock, en, reset: in std_logic;                 --reset active high
            data_out : out std_logic_vector( n-1 downto 0));
 end component;

 component flip_flop is
     port ( data_in : in std_logic;
            clock, en, reset: in std_logic; --reset attivo alto
            data_out : out std_logic);
 end component;

 component point_addition_RADIX2 is
    port( x1, x2, y1, y2, z1, z2 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x3,y3,z3 : out std_logic_vector( 255 downto 0));
 end component;

 component point_doubling_RADIX2 is
    port( x1, y1, z1 : in std_logic_vector(255 downto 0);
          clock, reset, start : in std_logic;          --reset active high 
          done : out std_logic;
          x2,y2,z2 : out std_logic_vector( 255 downto 0));
 end component;

component Counter_modified is
    Port ( clock, reset, en : in std_logic;
           count : out std_logic_vector(7 downto 0));
end component;

  begin


reg0: reg generic map ( n => 256 )
          port map ( K , clock, load_R0, reset, R0_out );

mux0: mux256to1 generic map (n => 256)
              port map ( mux0_sel, R0_out, mux0_out);

mux0_sel <= count;

done_L <= done_pa and reg1_out;

----- MUX 1 -----

mux1_x: mux2to1 generic map (n => 256)
              port map ( Gx, mux4_x_out, mux1_sel, mux1_x_out);

mux1_y: mux2to1 generic map (n => 256)
              port map ( Gy, mux4_y_out, mux1_sel, mux1_y_out);

mux1_z: mux2to1 generic map (n => 256)
              port map ( Gz, mux4_z_out, mux1_sel, mux1_z_out);

----- MUX 2 -----


mux2_x: mux2to1 generic map (n => 256)
              port map ( Gx2, mux5_x_out, mux2_sel, mux2_x_out);

mux2_y: mux2to1 generic map (n => 256)
              port map ( Gy2, mux5_y_out, mux2_sel, mux2_y_out);

mux2_z: mux2to1 generic map (n => 256)
              port map ( Gz2, mux5_z_out, mux2_sel, mux2_z_out);

----- MUX 3 -----


mux3_x: mux2to1 generic map (n => 256)
              port map ( mux1_x_out, mux2_x_out, mux3_sel, mux3_x_out);

mux3_y: mux2to1 generic map (n => 256)
              port map ( mux1_y_out, mux2_y_out, mux3_sel, mux3_y_out);

mux3_z: mux2to1 generic map (n => 256)
              port map ( mux1_z_out, mux2_z_out, mux3_sel, mux3_z_out);

----- POINT ADDITION - POINT DOUBLING -----


PA : point_addition_RADIX2 port map (mux1_x_out, mux2_x_out, mux1_y_out, mux2_y_out, mux1_z_out, mux2_z_out, clock, reset_PA, start_PA, done_PA, PA_x, PA_y, PA_z);
PD : point_doubling_RADIX2 port map (reg4_x_out, reg4_y_out, reg4_z_out, clock, reset_PD, start_PD, done_PD, PD_x,PD_y,PD_z);


reg3_x: reg generic map ( n => 256 )
          port map ( PD_x , clock, done_PD, reset, PD1_x );

reg3_y: reg generic map ( n => 256 )
          port map ( PD_y , clock, done_PD, reset, PD1_y );

reg3_z: reg generic map ( n => 256 )
          port map ( PD_z , clock, done_PD, reset, PD1_z );


reg4_x: reg generic map ( n => 256 )
          port map ( mux3_x_out , clock, start_PD, reset, reg4_x_out );

reg4_y: reg generic map ( n => 256 )
          port map ( mux3_y_out , clock, start_PD, reset, reg4_y_out );

reg4_z: reg generic map ( n => 256 )
          port map ( mux3_z_out , clock, start_PD, reset, reg4_z_out );


----- MUX 4 -----


mux4_x: mux2to1 generic map (n => 256)
              port map ( PD1_x, PA_x, mux4_sel, mux4_x_out);

mux4_y: mux2to1 generic map (n => 256)
              port map ( PD1_y, PA_y, mux4_sel, mux4_y_out);

mux4_z: mux2to1 generic map (n => 256)
              port map ( PD1_z, PA_z, mux4_sel, mux4_z_out);


----- MUX 5 -----


mux5_x: mux2to1 generic map (n => 256)
              port map ( PA_x, PD1_x, mux5_sel, mux5_x_out);

mux5_y: mux2to1 generic map (n => 256)
              port map ( PA_y, PD1_y, mux5_sel, mux5_y_out);

mux5_z: mux2to1 generic map (n => 256)
              port map ( PA_z, PD1_z, mux5_sel, mux5_z_out);


---- REGQ ----


regQ_x: reg generic map ( n => 256 )
          port map (mux4_x_out, clock, regQ_load, reset_Q, Qx );

regQ_y: reg generic map ( n => 256 )
          port map (mux4_y_out, clock, regQ_load, reset_Q, Qy );

regQ_z: reg generic map ( n => 256 )
          port map (mux4_z_out, clock, regQ_load, reset_Q, Qz );

----- R1-R2 -----

reg1: flip_flop port map (done_PD, clock, done_PD, reg1_reset, reg1_out );
reg2: flip_flop port map (mux0_out, clock, reg2_load, reg2_reset, reg2_out );

cnt : counter_modified port map ( clock, cnt_reset, cnt_en, count);


 end architecture;
