library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CLA_64bit is 

    port( a_in,b_in : in std_logic_vector( 63 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 63 downto 0));

end entity;

architecture architectural of CLA_64bit is

signal g0, g1, g2, g3, p0, p1, p2, p3, c0, c1, c2, c3 : std_logic;

component CLA_4in_block is 
    port( g0, g1, g2, g3, p0, p1, p2, p3, c_in : in std_logic;
          g_out, p_out, c0, c1, c2, c3 : out std_logic);
end component;


component CLA_16bit is 
    port( a_in,b_in : in std_logic_vector( 15 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 15 downto 0));
end component;

begin

t0: CLA_16bit port map (a_in(15 downto 0), b_in(15 downto 0), c0, g0, p0, s(15 downto 0));
t1: CLA_16bit port map (a_in(31 downto 16), b_in(31 downto 16), c1, g1, p1, s(31 downto 16));
t2: CLA_16bit port map (a_in(47 downto 32), b_in(47 downto 32), c2, g2, p2, s(47 downto 32));
t3: CLA_16bit port map (a_in(63 downto 48), b_in(63 downto 48), c3, g3, p3, s(63 downto 48));

in4_block: CLA_4in_block port map (g0, g1, g2, g3, p0, p1, p2, p3, c_in, g_out, p_out, c0, c1, c2, c3);



end architecture;
