library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-- old implementation --

--entity CLA_4in_block is 
--
--    port( g0, g1, g2, g3, p0, p1, p2, p3, c_in : in std_logic;
--          g_out, p_out, c0, c1, c2, c3 : out std_logic);
--
--end entity;
--
--architecture architectural of CLA_4in_block is
--
--signal c1_b3, c0_b3, g_32, p_32, g_01, p_01 : std_logic;
--
--component B is 
--    port( g1, g0, p1, p0, c_in : in std_logic;
--          g_out, p_out, c1, c0 : out std_logic);
--end component;
--
--begin
--
--b0: B port map( g3, g2, p3, p2, c1_b3, g_32, p_32, c3, c2);
--b1: B port map( g1, g0, p1, p0, c0_b3, g_01, p_01, c1, c0);
--b2: B port map( g_32, g_01, p_32, p_01, c_in, g_out, p_out, c1_b3, c0_b3);
--
--end architecture;

entity CLA_4in_block is 

    port( g0, g1, g2, g3, p0, p1, p2, p3, c_in : in std_logic;
          g_out, p_out, c0, c1, c2, c3 : out std_logic);

end entity;

architecture architectural of CLA_4in_block is

signal and_0, and_1, and_2, and_3, and_4, and_5, and_7, and_8, and_9 : std_logic;

begin

c0 <= c_in;

and_0 <= c_in and p0;
c1 <= and_0 or g0;

and_1 <= c_in and p0 and p1;
and_2 <= g0 and p1;
c2 <= g1 or and_1 or and_2;

and_3 <= c_in and p0 and p1 and p2;
and_4 <= g0 and p1 and p2;
and_5 <= g1 and p2;
c3 <= g2 or and_5 or and_4 or and_3;

p_out <= p0 and p1 and p2 and p3;

and_7 <= g0 and p1 and p2 and p3;
and_8 <= g1 and p2 and p3;
and_9 <= g2 and p3;
g_out <= g3 or and_9 or and_8 or and_7;

end architecture;












