library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CLA_4bit is 

    port( a_in,b_in : in std_logic_vector( 3 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 3 downto 0));

end entity;

architecture architectural of CLA_4bit is

signal g0, g1, g2, g3, p0, p1, p2, p3, c0, c1, c2, c3 : std_logic;

component CLA_4in_block is 
    port( g0, g1, g2, g3, p0, p1, p2, p3, c_in : in std_logic;
          g_out, p_out, c0, c1, c2, c3 : out std_logic);
end component;

component A is 
    port( a, b, c_in : in std_logic;
          g,p, s : out std_logic);
end component;

begin

a_0: A port map (a_in(0), b_in(0), c0, g0, p0, s(0));
a_1: A port map (a_in(1), b_in(1), c1, g1, p1, s(1));
a_2: A port map (a_in(2), b_in(2), c2, g2, p2, s(2));
a_3: A port map (a_in(3), b_in(3), c3, g3, p3, s(3));

in4_block: CLA_4in_block port map (g0, g1, g2, g3, p0, p1, p2, p3, c_in, g_out, p_out, c0, c1, c2, c3);



end architecture;
