library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CLA_259bit is  --------- 259 BIT input/output ---------

    port( a_in,b_in : in std_logic_vector( 258 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 258 downto 0));

end entity;

architecture architectural of CLA_259bit is

signal g_out, g_out1, g0, g1,  p_out, p_out1, p0, p1, c_b, c_out, c0, c1, g_outb, p_outb : std_logic;

component B is 
    port( g1, g0, p1, p0, c_in : in std_logic;
          g_out, p_out, c1, c0 : out std_logic);
end component;

component A is 
    port( a, b, c_in : in std_logic;
          g, p, s : out std_logic);
end component;

component CLA_257bit is 
    port( a_in,b_in : in std_logic_vector( 256 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 256 downto 0));
end component;


begin

cla: CLA_257bit port map (a_in(256 downto 0), b_in(256 downto 0), c_b, g_out, p_out, s(256 downto 0));

a_0: A port map(a_in(257), b_in(257), c0, g0, p0, s(257));
a_1: A port map(a_in(258), b_in(258), c1, g1, p1, s(258));

b1: B port map( g_out1, g_out, p_out1, p_out, c_in, g_outb, p_outb, c_out, c_b);
b2: B port map(g1, g0, p1, p0, c_out, g_out1, p_out1, c1, c0);

end architecture;
