library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CLA_258bit is --------- 258 BIT input/output ---------

    port( a_in,b_in : in std_logic_vector( 257 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 257 downto 0));

end entity;

architecture architectural of CLA_258bit is

signal g_out, g_out1,  p_out, p_out1, c_b, c_out, g_outb, p_outb, g_out2, g_out3, p_out2, p_out3, c_0, c_1 : std_logic;

component B is 
    port( g1, g0, p1, p0, c_in : in std_logic;
          g_out, p_out, c1, c0 : out std_logic);
end component;

component A is 
    port( a, b, c_in : in std_logic;
          g, p, s : out std_logic);
end component;

component CLA_256bit is 
    port( a_in,b_in : in std_logic_vector( 255 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 255 downto 0));
end component;


begin

cla: CLA_256bit port map (a_in(255 downto 0), b_in(255 downto 0), c_b, g_out, p_out, s(255 downto 0));
a_n1: A port map(a_in(256), b_in(256), c_0, g_out2, p_out2, s(256));
a_n2: A port map(a_in(257), b_in(257), c_1, g_out3, p_out3, s(257));
b_n1: B port map( g_out1, g_out, p_out1, p_out, c_in, g_outb, p_outb, c_out, c_b);
b_n2: B port map( g_out3, g_out2, p_out3, p_out2, c_out, g_out1, p_out1, c_1, c_0);


end architecture;
