library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CLA_257bit is --------- 257 BIT input/output ---------

    port( a_in,b_in : in std_logic_vector( 256 downto 0);
          c_in : in std_logic;
          s : out std_logic_vector( 256 downto 0));

end entity;

architecture architectural of CLA_257bit is

signal g_out, g_out1,  p_out, p_out1, c_b, c_out, g_outb, p_outb : std_logic;

component B is 
    port( g1, g0, p1, p0, c_in : in std_logic;
          g_out, p_out, c1, c0 : out std_logic);
end component;

component A is 
    port( a, b, c_in : in std_logic;
          g, p, s : out std_logic);
end component;

component CLA_256bit is 
    port( a_in,b_in : in std_logic_vector( 255 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 255 downto 0));
end component;


begin

cla: CLA_256bit port map (a_in(255 downto 0), b_in(255 downto 0), c_b, g_out, p_out, s(255 downto 0));
a_n: A port map(a_in(256), b_in(256), c_out, g_out1, p_out1, s(256));
b_n: B port map( g_out1, g_out, p_out1, p_out, c_in, g_outb, p_outb, c_out, c_b);


end architecture;
