library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CLA_256bit is   -------- 256 BIT input/output ------

    port( a_in,b_in : in std_logic_vector( 255 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 255 downto 0));

end entity;

architecture architectural of CLA_256bit is

signal g0, g1, g2, g3, p0, p1, p2, p3, c0, c1, c2, c3 : std_logic;

component CLA_4in_block is 
    port( g0, g1, g2, g3, p0, p1, p2, p3, c_in : in std_logic;
          g_out, p_out, c0, c1, c2, c3 : out std_logic);
end component;


component CLA_64bit is 
    port( a_in,b_in : in std_logic_vector( 63 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 63 downto 0));
end component;

begin

t0: CLA_64bit port map (a_in(63 downto 0), b_in(63 downto 0), c0, g0, p0, s(63 downto 0));
t1: CLA_64bit port map (a_in(127 downto 64), b_in(127 downto 64), c1, g1, p1, s(127 downto 64));
t2: CLA_64bit port map (a_in(191 downto 128), b_in(191 downto 128), c2, g2, p2, s(191 downto 128));
t3: CLA_64bit port map (a_in(255 downto 192), b_in(255 downto 192), c3, g3, p3, s(255 downto 192));

in4_block: CLA_4in_block port map (g0, g1, g2, g3, p0, p1, p2, p3, c_in, g_out, p_out, c0, c1, c2, c3);



end architecture;
