library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CLA_16bit is 

    port( a_in,b_in : in std_logic_vector( 15 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 15 downto 0));

end entity;

architecture architectural of CLA_16bit is

signal g0, g1, g2, g3, p0, p1, p2, p3, c0, c1, c2, c3 : std_logic;

component CLA_4in_block is 
    port( g0, g1, g2, g3, p0, p1, p2, p3, c_in : in std_logic;
          g_out, p_out, c0, c1, c2, c3 : out std_logic);
end component;


component CLA_4bit is 
    port( a_in,b_in : in std_logic_vector( 3 downto 0);
          c_in : in std_logic;
          g_out, p_out : out std_logic;
          s : out std_logic_vector( 3 downto 0));
end component;

begin

t0: CLA_4bit port map (a_in(3 downto 0), b_in(3 downto 0), c0, g0, p0, s(3 downto 0));
t1: CLA_4bit port map (a_in(7 downto 4), b_in(7 downto 4), c1, g1, p1, s(7 downto 4));
t2: CLA_4bit port map (a_in(11 downto 8), b_in(11 downto 8), c2, g2, p2, s(11 downto 8));
t3: CLA_4bit port map (a_in(15 downto 12), b_in(15 downto 12), c3, g3, p3, s(15 downto 12));

in4_block: CLA_4in_block port map (g0, g1, g2, g3, p0, p1, p2, p3, c_in, g_out, p_out, c0, c1, c2, c3);



end architecture;
