$(document).ready(function() {
    // Double click on IPP
    $("#ipp-list > li").dblclick(function() {
        const ippId = $(this).data('ipp-id');

        $.ajax({
            url: `/form/ipps/${ippId}/forms/`,
            method: 'GET',
            dataType: 'json',
            success: function(data) {
                // Empty the form list and populate it with new data
                $("#form-list").empty();
                data.forEach(form => {
                    $("#form-list").append(`<li data-form-id="${form.id}">${form.name}</li>`);
                });
            }
        });
    });

    // Use event delegation for double click on Form
    $("#form-list").on('dblclick', 'li', function() {
        const formId = $(this).data('form-id');

        $.ajax({
            url: `/form/forms/${formId}/field_mappings/`,
            method: 'GET',
            dataType: 'json',
            success: function(data) {
                // Empty the field mappings list and populate it with new data
                $("#fieldmapping-list").empty();
                data.forEach(mapping => {
                    $("#fieldmapping-list").append(`
                        <li>
                            Field: ${mapping.db_field_name} | 
                            Data Mapping: ${mapping.field_location}
                        </li>
                    `);
                });
            }
        });
    });
});

