document.getElementById('cy').style.width = window.innerWidth + 'px';
window.addEventListener('resize', () => {
    document.getElementById('cy').style.width = window.innerWidth + 'px';
});
var cy = cytoscape({
    container: document.getElementById('cy'),
    elements: {
        nodes: graphData.nodes.map(node => ({
            data: {
                id: node.data.id,
                label: node.data.label,
                type: node.data.type,
                layer: node.data.layer,
                generators: node.data.generators,
                loads: node.data.loads,
                capacitors: node.data.capacitors,
                transformers: node.data.transformers,
                voltage: node.data.voltage,
                switches: node.data.switches,
            },
            position: {
                x: node.data.X,
                y: node.data.Y
            }
        })),
        edges: graphData.edges,
    },
    style: [
        {
            selector: 'node[type = "label"]',
            style: {
                'width': 1, // Small circle for label nodes
                'height': 1,
                'background-color': '#000', // Black background color for the small circle
                'label': 'data(label)', // Display label from node data
                'text-halign': 'center',
                'text-valign': 'center',
                'text-margin-x': 1, // You can adjust this value to position your text correctly
                'font-size': 3, // Large font size for label nodes
                'color': '#000', // Black text color
                'text-outline-width': 2, // Width of the text outline
                'text-outline-color': '#00FF00', // Green outline color
            },
        },
        {
            selector: 'node',
            style: {
                'label': 'data(label)',
                'shape': function(ele) {
                    var layer = ele.data('layer');
                    if (layer === 'TX3Winding') {
                        return 'triangle';
                    } else if (layer === 'switch' || layer === 'lvSwitch' || layer === 'doubleSwitch') {
                        return 'rectangle';  // Square shape for 'Switch'
                    }
                    return 'ellipse'; // Default shape
                },
                'width': function(ele) {
                    var layer = ele.data('layer');
                    if (layer === 'TX3Winding') {
                        return 4.5;
                    } else if (layer === 'load_feeder') {
                        return 5;
                    } else if (layer === 'switch') {
                        return 2;
                    } else if (layer === 'lvSwitch' || layer === 'none') {
                        return 2;
                    } else if (layer === 'doubleSwitch') {
                        return 3;
                    } else if (layer === 'generator' || layer === 'capacitor' || layer === 'both') {
                        return 5;
                    }
                    return 2;  // Default width
                },
                'height': function(ele) {
                    var layer = ele.data('layer');
                    if (layer === 'TX3Winding') {
                        return 4.5;
                    } else if (layer === 'load_feeder') {
                        return 5;
                    } else if (layer === 'switch') {
                        return 2;
                    } else if (layer === 'lvSwitch' || layer === 'none') {
                        return 2;
                    } else if (layer === 'doubleSwitch') {
                        return 3;
                    } else if (layer === 'generator' || layer === 'capacitor' || layer === 'both') {
                        return 5;
                    }
                    return 2;  // Default height
                },
                'font-size': 2, // Adjust the font size of the label
                'background-color': function(ele) {
                    var layer = ele.data('layer');
                    if (layer === 'generator') {
                        return 'red';
                    } else if (layer === 'load_etap') {
                        return 'rgb(173, 216, 230)'; // light blue
                    } else if (layer === 'both') {
                        return 'purple';
                    } else if (layer === 'load_feeder') {
                        return 'blue';
                    } else if (layer === 'capacitor') {
                        return '#FF69B4';
                    } else if (layer === 'switch') {
                        return '#006400';
                    } else if (layer === 'lvSwitch') {
                        return '#90EE90';
                    } else if (layer === 'doubleSwitch') {
                        return '#004d00';
                    } else if (layer === 'none') {
                        return 'grey';
                    } else if (layer === 'TX3Winding') {
                        return 'brown';
                    } else {
                        return 'pink';  // Default color for nodes with unknown type
                    }
                },
            }
        },
        {
            selector: 'edge',
            style: {
                'width': function(ele) {
                    if (ele.data('layer') === 'edge') {
                        return 1;  // Thinner width for 'edge' layer
                    }
                    return 1;
                },
                'line-color': function(ele) {
                    var status = ele.data('status');
                    var layer = ele.data('layer');

                    if (status === 'Open') {
                        return 'rgba(255, 182, 193, 0.5)';
                    } else if (status === 'Closed' && layer === 'conductor') {
                        return '#ccc';
                    } else if (layer === 'edge') {
                        return 'rgba(150, 150, 150, 0.5)';  // darker grey for 'edge' layer
                    }

                    return 'rgba(0, 255, 0, 0.5)';  // Default color
                },
                'line-style': function(ele) {
                    if (ele.data('layer') === 'edge') {
                        return 'dotted';
                    }
                    return 'solid';  // Default is solid
                },
                'curve-style': 'bezier',
                'mid-target-arrow-shape': function(ele) {
                    var status = ele.data('TX');
                    if (status === 'Transformer' || status === 'TX3Winding') {
                        return 'triangle';
                    }
                    return 'none'; // No arrow shape for other statuses
                },
                'mid-target-arrow-color': function(ele) {
                    var status = ele.data('TX');
                    if (status === 'Transformer') {
                        return '#DAA520';
                    }
                    if (status === 'TX3Winding') {
                        return 'brown';
                    }
                    return '#ccc'; // No arrow color for other statuses
                },
                'arrow-scale': 0.5,
            }
        }
    ],
    layout: {
        name: 'preset' // Use 'preset' layout to maintain the specified positions
    },
    data: { /* ... */ },

    // initial viewport state:
    zoom: 1,
    pan: { x: 0, y: 0 },

    // interaction options:
    minZoom: 1,
    maxZoom: 10,
    zoomingEnabled: true,
    userZoomingEnabled: true,
    panningEnabled: true,
    userPanningEnabled: true,
    boxSelectionEnabled: true,
    selectionType: 'single',
    touchTapThreshold: 8,
    desktopTapThreshold: 4,
    autolock: false,
    autoungrabify: false,
    autounselectify: false,
    multiClickDebounceTime: 250,

    // rendering options:
    headless: false,
    styleEnabled: true,
    hideEdgesOnViewport: false,
    textureOnViewport: false,
    motionBlur: false,
    motionBlurOpacity: 0.2,
    wheelSensitivity: 0.25,
    pixelRatio: 'auto'
});

function extractComponents() {
    // Send AJAX request to execute parse_xml_and_save() function
    fetch('/network/extract_components/')
        .then(response => response.json())
        .then(data => {
            // Handle response if needed
            console.log(data);
        })
        .catch(error => {
            // Handle error if needed
            console.error(error);
        });
}

function buildNetwork() {
    // Send AJAX request to execute populate_network_from_components() function
    fetch('/network/build_network/')
        .then(response => response.json())
        .then(data => {
            // Handle response if needed
            console.log(data);
        })
        .catch(error => {
            // Handle error if needed
            console.error(error);
        });
}
function getCsrfToken() {
    return document.querySelector('[name=csrfmiddlewaretoken]').value;
}
function savePositions() {
    var positions = cy.nodes().map(function( node ){
        return {
            id: node.data('id'),
            type: node.data('type'),
            label: node.data('label'),
            position: node.position()
        };
    });

    console.log(positions);
    // Next, send this data to your server to update the Node model
    updateNodePositions(positions);
}
function updateNodePositions(positions) {
    const csrftoken = getCsrfToken();
    fetch('/network/save_positions/', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRFToken': csrftoken,
        },
        body: JSON.stringify({ positions: positions }),
    })
    .then(response => response.json())
    .then(data => {
        console.log('Success:', data);
    })
    .catch((error) => {
        console.error('Error:', error);
    });
}
var popup = document.getElementById('info-popup');
var tappedBefore;
var tappedTimeout;
var lastDoubleClickedElement = null;
cy.on('tap', 'node', function(evt) {
    var node = evt.target;
    var metadata = node.data();
    lastDoubleClickedElement = node;
    if (tappedBefore) {
        clearTimeout(tappedTimeout);
    }

    if (tappedBefore && tappedBefore.id() === node.id()) {
        // Double tap event
        tappedTimeout = setTimeout(() => tappedBefore = null, 300);
        tappedBefore = null;

        var infoContent = '';
        if (metadata.generators) {
            infoContent += `<pre>${metadata.generators.replace(/\n/g, '<br>')}</pre>`;
        }
        if (metadata.loads) {
            infoContent += `<pre>${metadata.loads.replace(/\n/g, '<br>')}</pre>`;
        }
        if (metadata.capacitors) {
            infoContent += `<pre>${metadata.capacitors.replace(/\n/g, '<br>')}</pre>`;
        }
        if (metadata.transformers) {
            infoContent += `<pre>${metadata.transformers.replace(/\n/g, '<br>')}</pre>`;
        }
        if (metadata.switches) {
            infoContent += `<pre>${metadata.switches.replace(/\n/g, '<br>')}</pre>`;
        }
        if (metadata.voltage) {
            infoContent += `<pre>${metadata.voltage}</pre>`;
        }

        popup.innerHTML = infoContent;
        console.log(node.renderedPosition());
        lastDoubleClickedElement = node;
        updatePopupPosition(node);
        popup.style.display = 'block';
    } else {
        tappedBefore = node;
        tappedTimeout = setTimeout(() => tappedBefore = null, 300);
        // Single tap event code (if any) can go here
    }
});

cy.on('tap', 'edge', function(evt) {
    var edge = evt.target;
    var metadata = edge.data();
    lastDoubleClickedElement = edge;
    if (tappedBefore) {
        clearTimeout(tappedTimeout);
    }

    if (tappedBefore && tappedBefore.id() === edge.id()) {
        // Double tap event
        tappedTimeout = setTimeout(() => tappedBefore = null, 300);
        tappedBefore = null;

        var infoContent = '';
        if (metadata.transformers) {
            infoContent += `<pre>${metadata.transformers.replace(/\n/g, '<br>')}</pre>`;
        }
        if (metadata.conductors) {
            infoContent += `<pre>${metadata.conductors.replace(/\n/g, '<br>')}</pre>`;
        }


        popup.innerHTML = infoContent;
        console.log(edge.renderedPosition());
        updatePopupPosition(edge);
        popup.style.display = 'block';
    } else {
        tappedBefore = edge;
        tappedTimeout = setTimeout(() => tappedBefore = null, 300);
        // Single tap event code (if any) can go here
    }
});
cy.on('pan zoom resize', function() {
    if (lastDoubleClickedElement !== null) {
        updatePopupPosition(lastDoubleClickedElement);
    }
});

cy.on('tap', function(evt) {
    var target = evt.target;
    if (cy === target) {
        popup.style.display = 'none';
    }
});
function updatePopupPosition(ele) {
    var renderedPos;
    var popupHeight = popup.offsetHeight;
    if(ele.isNode()) {
        renderedPos = ele.renderedPosition();
    } else if(ele.isEdge()) {
        var sourcePos = ele.source().renderedPosition();
        var targetPos = ele.target().renderedPosition();
        renderedPos = {
            x: (sourcePos.x + targetPos.x) / 2,
            y: (sourcePos.y + targetPos.y) / 2,
        };
    }
    if (renderedPos) {
        popup.style.top = (renderedPos.y - popupHeight + 325) + 'px'; // Adjust the offset value as necessary
        popup.style.left = (renderedPos.x + 50) + 'px'; // Adjust the offset value as necessary
    }
}

var nodeLegendDiv = document.getElementById('node-legend');
var edgeLegendDiv = document.getElementById('edge-legend');

const nodelegendItems = [
    { label: 'Generator', color: 'red', width: '19px', height: '19px' },
    { label: 'Capacitor', color: '#FF69B4', width: '19px', height: '19px' },
    { label: 'Forecast Load', color: 'blue', width: '19px', height: '19px' },
    { label: 'Static Load', color: 'rgb(173, 216, 230)', width: '14px', height: '14px' },
    { label: 'No Injection', color: 'grey', width: '14px', height: '14px' },
    { label: 'Transformer 3W', shape: 'triangle', color: 'brown', width: '10px' },
    { label: 'Transformer 2W', shape: 'triangle', color: '#DAA520', width: '10px' },
    { label: 'LV Switch', shape: 'rectangle', color: '#90EE90', width: '14px', height: '14px' },
    { label: 'HV Switch', shape: 'rectangle', color: '#006400', width: '17px', height: '17px' },
    { label: 'doubleSwitch', shape: 'rectangle', color: '#004d00', width: '18px', height: '18px' },
];

const edgelegendItems = [
    { label: 'Open', color: 'rgba(255, 182, 193, 0.5)', shape: 'rectangle', width:'30px', height: '10px' },
    { label: 'cable/line', color: '#ccc', shape: 'rectangle', width:'30px', height: '10px' },
    { label: 'connector', color: 'rgba(50, 50, 50, 0.5)', shape: 'dotted', width:'10px', height: '10px' },
];

function createLegendItem(legendDiv, item) {
    var legendItem = document.createElement('div');
    legendItem.className = 'legend-item';

    var shapeBox = document.createElement('div');
    shapeBox.className = 'shape-box';

    if (item.shape === 'dotted') {
        // Create two divs for two squares.
        var dot1 = document.createElement('div');
        var dot2 = document.createElement('div');

        dot1.style.backgroundColor = item.color;
        dot2.style.backgroundColor = item.color;

        dot1.style.width = item.width;
        dot1.style.height = item.height;
        dot2.style.width = item.width;
        dot2.style.height = item.height;

        dot1.style.display = 'inline-block';
        dot2.style.display = 'inline-block';
        dot1.style.marginRight = `calc(${item.width} / 2)`;

        shapeBox.appendChild(dot1);
        shapeBox.appendChild(dot2);
    } else if (item.shape === 'triangle') {
        shapeBox.style.width = '0';
        shapeBox.style.height = '0';
        shapeBox.style.borderLeft = `${item.width} solid transparent`;
        shapeBox.style.borderRight = `${item.width} solid transparent`;
        shapeBox.style.borderBottom = `calc(2 * ${item.width}) solid ${item.color}`;
    } else if (item.shape === 'rectangle') {
        shapeBox.style.backgroundColor = item.color;
        shapeBox.style.width = item.width || '20px';
        shapeBox.style.height = item.height || '10px';
    } else {  // Default to circle
        shapeBox.style.backgroundColor = item.color;
        shapeBox.style.width = item.width || '18px';
        shapeBox.style.height = item.width || '18px';
        shapeBox.style.borderRadius = '50%';
    }

    var labelText = document.createTextNode(item.label);
    legendItem.appendChild(shapeBox);
    legendItem.appendChild(labelText);
    legendDiv.appendChild(legendItem);
}

nodelegendItems.forEach(item => createLegendItem(nodeLegendDiv, item));
edgelegendItems.forEach(item => createLegendItem(edgeLegendDiv, item));





