cy.contextMenus({
    menuItems: [
        {
            id: 'switch',
            content: 'Switch',
            selector: 'node[layer="switch"], node[layer="lvSwitch"], node[layer="doubleSwitch"]',  // Only show for specific nodes
            onClickFunction: function (event) {
                var target = event.target || event.cyTarget;
                var id = target.data('id');

                // Use the absolute path to the desired endpoint
                var baseUrl = window.location.origin;
                var endpointUrl = `${baseUrl}/network/update_switch_status/${id}/`;

                fetch(endpointUrl, {
                    method: 'POST',
                    // other necessary headers and body data
                }).then(response => response.json()).then(data => {
                    console.log(data);
                }).catch(error => {
                    console.error('Error:', error);
                });
            },
            hasTrailingDivider: true
        },
        // You can add more menu items here if needed
    ],
    fillColor: 'rgba(0, 0, 0, 0.75)', // Background color of the context menu
    activeFillColor: 'rgba(1, 105, 217, 0.75)', // Background color of active menu items
    activePadding: 20, // Padding of active menu items
    indicatorSize: 24, // Size of the active item indicator
    separatorWidth: 3, // Width of menu item separators
    spotlightPadding: 4, // Padding of spotlight
    minSpotlightRadius: 24, // Minimum radius of spotlight
    maxSpotlightRadius: 38, // Maximum radius of spotlight
    openMenuEvents: 'cxttapstart taphold', // Events that open the menu
    itemColor: 'white', // Text color of menu items
    itemTextShadowColor: 'transparent', // Text shadow color of menu items
    zIndex: 9999, // z-index of the menu
    atMouse: false // Draw menu at mouse position
});