const urlSegments = window.location.pathname.split('/');
const starttime = urlSegments[urlSegments.length - 3];
const endtime = urlSegments[urlSegments.length - 2];

const colorToHue = {
    purple: 270,
    red: 0,
    green: 120,
    blue: 240,
    yellow: 60,
    cyan: 180,
    magenta: 300,
    orange: 30,
    pink: 350,
    brown: 20,
    grey: 0, // Grey doesn't have a specific hue; it will yield a different effect in HSL
    lime: 90,
    maroon: 0, // Maroon is a shade of red, so we use the hue for red
};

const ParameterValue = {
    P: 'P',
    Q: 'Q',
    V_AB: 'V_AB',
    V_BC: 'V_BC',
    V_AC: 'V_AC',
    temperature: 'Temperature',
    humidity: 'Humidity',
    irradiance: 'Irradiance',
    rainfall: 'Rainfall',
    windspeed: 'Windspeed',
    winddirection: 'Wind Direction',
    riverlevel: 'River Level',
};

const ParameterShape = {
    P: 'circle',
    Q: 'rectRounded',
    V_AB: 'triangle',
    V_BC: 'triangle',
    V_AC: 'triangle',
    temperature: 'rect',
    humidity: 'rectRounded',
    irradiance: 'line',
    rainfall: 'dash',
    windspeed: 'crossRot',
    winddirection: 'cross',
    riverlevel: 'star',
};

const loadCenterColors = {
    BMP: colorToHue['purple'],
    BZE: colorToHue['red'],
    CCK: colorToHue['green'],
    CZL: colorToHue['blue'],
    DGA: colorToHue['yellow'],
    IND: colorToHue['cyan'],
    LDV: colorToHue['magenta'],
    MUL: colorToHue['orange'],
    OWK: colorToHue['pink'],
    PGA: colorToHue['brown'],
    SIG: colorToHue['grey'],
    SPR: colorToHue['lime'],
    WST: colorToHue['maroon'],
};

const feeders = {
    BMP01: 'BMP',
    BMP02: 'BMP',
    BMP03: 'BMP',
    BMP04: 'BMP',
    BZE01: 'BZE',
    BZE02: 'BZE',
    BZE03: 'BZE',
    BZE04: 'BZE',
    BZE05: 'BZE',
    BZE06: 'BZE',
    CCK01: 'CCK',
    CCK02: 'CCK',
    CZL01: 'CZL',
    CZL02: 'CZL',
    CZL03: 'CZL',
    CZL04: 'CZL',
    CZL05: 'CZL',
    CZL06: 'CZL',
    DGA01: 'DGA',
    DGA02: 'DGA',
    DGA03: 'DGA',
    IND01: 'IND',
    IND02: 'IND',
    IND03: 'IND',
    LDV01: 'LDV',
    LDV02: 'LDV',
    LDV03: 'LDV',
    MUL01: 'MUL',
    OWK01: 'OWK',
    OWK02: 'OWK',
    OWK03: 'OWK',
    OWK04: 'OWK',
    PGA01: 'PGA',
    PGA02: 'PGA',
    PGA03: 'PGA',
    SIG01: 'SIG',
    SIG02: 'SIG',
    SIG03: 'SIG',
    SIG04: 'SIG',
    SPR01: 'SPR',
    SPR02: 'SPR',
    SPR03: 'SPR',
    SPR04: 'SPR',
    WST01: 'WST',
};

const feederColors = {};