let groupedData = {};
let selectedParameters = ['temperature'];
let myChart;

function myParameterFunction() {
    document.getElementById("myParameterDropdown").classList.toggle("show");
}
function myLoadCenterFunction() {
    document.getElementById("myLoadCenterDropdown").classList.toggle("show");
}
function getShade(baseHue, index, maxIndex) {
    return `hsl(${baseHue}, ${Math.floor(100 - (index / maxIndex * 60))}%, ${Math.floor(50 + (index / maxIndex * 40))}%)`;
}

Object.keys(feeders).forEach(feeder => {
    const loadCenter = feeders[feeder];
    const baseHue = loadCenterColors[loadCenter];
    const siblings = Object.keys(feeders).filter(f => feeders[f] === loadCenter);
    const index = siblings.indexOf(feeder);
    feederColors[feeder] = getShade(baseHue, index, siblings.length - 1);
});

function createParameterDropdown() {
    const parameterDropdown = document.getElementById('myParameterDropdown');

    Object.keys(ParameterValue).forEach(parameterKey => {
        const wrapper = document.createElement('div');
        wrapper.style.display = 'flex';
        wrapper.style.alignItems = 'center';

        const checkbox = document.createElement('input');
        checkbox.type = 'checkbox';
        checkbox.name = 'parameter';
        checkbox.value = parameterKey;
        checkbox.checked = parameterKey === 'P';

        const label = document.createElement('label');
        label.htmlFor = parameterKey;
        label.appendChild(document.createTextNode(ParameterValue[parameterKey]));

        wrapper.appendChild(checkbox);
        wrapper.appendChild(label);

        parameterDropdown.appendChild(wrapper);
    });
}

createParameterDropdown();
function createLoadCenterDropdown() {
  const loadCenterDropdown = document.getElementById('myLoadCenterDropdown');
  Object.keys(loadCenterColors).forEach(loadCenter => {
    const wrapper = document.createElement('div');
    wrapper.style.display = 'flex';
    wrapper.style.alignItems = 'center';

    const checkbox = document.createElement('input');
    checkbox.type = 'checkbox';
    checkbox.id = loadCenter;
    checkbox.name = 'loadCenter';
    checkbox.value = loadCenter;
    checkbox.checked = true;

    const label = document.createElement('label');
    label.htmlFor = loadCenter;
    label.appendChild(document.createTextNode(loadCenter));

    wrapper.appendChild(checkbox);
    wrapper.appendChild(label);

    loadCenterDropdown.appendChild(wrapper);
  });
}

// Call the function to create the load center dropdown menu at the end of your script
createLoadCenterDropdown();

// For select and deselect all functionality
function selectAllLoadCenters(selectAll = true) {
    document.querySelectorAll('input[name="loadCenter"]').forEach(elem => {
        elem.checked = selectAll;
    });

    // After updating the checkboxes, trigger the update to the chart
    const selectedParameters = getSelectedParameters();
    const selectedLoadCenters = getSelectedLoadCenters();
    const newDatasets = createDatasets(groupedData, selectedLoadCenters, selectedParameters);
    myChart.data.datasets = newDatasets;
    myChart.update();
}
document.getElementById('selectAll').addEventListener('click', () => selectAllLoadCenters(true));
document.getElementById('deselectAll').addEventListener('click', () => selectAllLoadCenters(false));

// Function to get the selected load centers
function getSelectedLoadCenters() {
    return Array.from(document.querySelectorAll('input[name="loadCenter"]:checked')).map(input => input.value);
}

function getSelectedParameters() {
    return Array.from(document.querySelectorAll('input[name="parameter"]:checked')).map(input => input.value);
}

// Function to create datasets (filtered by selected load centers and parameters)

function createDatasets(groupedData, selectedLoadCenters, selectedParameters) {
    let datasets = [];

    selectedLoadCenters.forEach(loadCenter => {
        let feedersInLoadCenter = Object.keys(groupedData).filter(feederName => feeders[feederName] === loadCenter);

        feedersInLoadCenter.forEach(feederName => {
            selectedParameters.forEach(parameter => {
                let dataSeries = groupedData[feederName].map(item => item[parameter]);

                // Normalize data if more than one parameter is selected
                if (selectedParameters.length > 1) {
                    const minVal = Math.min(...dataSeries);
                    const maxVal = Math.max(...dataSeries);
                    dataSeries = dataSeries.map(value => ((value - minVal) / (maxVal - minVal)) * 200 - 100);
                }
                datasets.push({
                    label: `${feederName}-${parameter}`,
                    data: dataSeries,
                    borderColor: feederColors[feederName],
                    borderWidth: 1,
                    fill: false,
                    pointStyle: ParameterShape[parameter],
                });
            });
        });
    });

    return datasets;
}

/* Graph for Load Forecast Page*/
const ctx = document.getElementById('myChart').getContext('2d');

// Fetch the JSON data from your Django view
fetch(`/LF/weather_load_json/?starttime=${starttime}&endtime=${endtime}`)
    .then(response => response.json())
    .then(data => {

        if (data.message === 'Empty Query') {
            document.getElementById('chartContainer').style.display = 'none';
            return;  // Exit early, no further processing needed
        } else {
            document.getElementById('chartContainer').style.display = 'block';
        }


        const results = JSON.parse(data.results);

        // Group data by feeder name
        groupedData = results.reduce((acc, cur) => {
            if (!acc[cur.FeederName]) acc[cur.FeederName] = [];
            acc[cur.FeederName].push(cur);
            return acc;
        }, {});

        const selectedLoadCenters = getSelectedLoadCenters(); // Get initially selected load centers
        const selectedParameters = getSelectedParameters(); // Get initially selected parameters

        // Create datasets based on initially selected load centers and parameters
        const datasets = createDatasets(groupedData, selectedLoadCenters, selectedParameters);

        // Create labels array (assuming all feeders have data for the same time points)
        const labels = results.map(item => item.time);

        // Build the chart
        myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: labels,
                datasets: datasets,
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: {
                        type: 'timeseries',
                        time: {
                        },
                    },
                },
            },
        });
    })
    .catch(error => {
        console.error('Error fetching data:', error);
    });
document.querySelectorAll('input[name="parameter"]').forEach(elem => {
        elem.addEventListener('change', () => {
            // Get selected parameters
            const selectedParameters = getSelectedParameters();
            const selectedLoadCenters = getSelectedLoadCenters();
            // Create new datasets with selected parameters
            const newDatasets = createDatasets(groupedData, selectedLoadCenters, selectedParameters);
            // Update the chart data and refresh the chart
            myChart.data.datasets = newDatasets;
            myChart.update();
        });
    });

document.querySelectorAll('input[name="loadCenter"]').forEach(elem => {
  elem.addEventListener('change', () => {
    const selectedParameters = getSelectedParameters(); // Update this function to get the selected parameters
    const selectedLoadCenters = getSelectedLoadCenters();
    const newDatasets = createDatasets(groupedData, selectedLoadCenters, selectedParameters); // Now groupedData and selectedParameters are accessible
    myChart.data.datasets = newDatasets;
    myChart.update();
  });
});
