// Function to show the context menu at the specified position
function showContextMenu(x, y) {
    const contextMenu = $('#context-menu');

    contextMenu.css({ left: x + 'px', top: y + 'px', display: 'block', 'z-index': '10001' });
}

// Function to close the context menu
function closeContextMenu() {
    $('#context-menu').css('display', 'none');
}

// Right-click event on the document
$(document).on('contextmenu', function (e) {
    e.preventDefault(); // Prevents default browser context menu from showing up

    // Show our custom context menu
    showContextMenu(e.pageX, e.pageY);
});

// Click event on "Create Event" in context menu
$('#create-event').on('click', function() {
    closeContextMenu();
    showPopup(event.pageX, event.pageY); // Show the event creation popup
});

// Close the context menu when clicking anywhere outside it
$(document).on('click', function(event) {
    if (!$(event.target).closest('#context-menu').length) {
        closeContextMenu();
    }
});

// Function to show the popup at the specified position
function showPopup(x, y) {
    // Set the position of the popup
    const eventPopup = $('#event-popup');
    const popupWidth = eventPopup.outerWidth();
    const popupHeight = eventPopup.outerHeight();

    const bodyWidth = $(document).width();
    const bodyHeight = $(document).height();

    const xPos = Math.min(x, bodyWidth - popupWidth);
    const yPos = Math.max(y - popupHeight, 0);

    eventPopup.css({ left: xPos + 'px', top: yPos + 'px', display: 'block', 'z-index': '10000' });
}

// Function to close the popup
function closePopup() {
    $('#event-popup').css('display', 'none');
}
// Function to set date fields in the form with the clicked date
function setFormDate(dateString) {
    // Convert the date string to the proper format (yyyy-MM-ddTHH:mm)
    const formattedDate = dateString + 'T00:00';
    $('#event-form input[name="start"]').val(formattedDate);
}