from django.shortcuts import render
from PPA.models import IPP
from django.http import JsonResponse
from datetime import datetime, date, timedelta
from PPA.utils import construct_price_matrix, convert_time_naive
from .utils import import_form_data
from .models import FormFormat, FieldMapping

def ipp_list(request):
    now = datetime.now()
    start_date = datetime(now.year, now.month, now.day, now.hour) + timedelta(hours=1)
    two_days_later = now + timedelta(days=2)
    end_date = datetime(two_days_later.year, two_days_later.month, two_days_later.day, 23, 0, 0)
    construct_price_matrix(start_date, end_date)
    ipps = IPP.objects.all()
    return render(request, 'ipp_list.html', {'ipps': ipps})

def form_list(request, ipp_id):
    forms = FormFormat.objects.filter(IPP_id=ipp_id)
    data = [{"id": form.id, "name": form.name} for form in forms]
    return JsonResponse(data, safe=False)

def field_mapping_list(request, form_id):
    mappings = FieldMapping.objects.filter(form_format_id=form_id)
    data = [
        {
            "id": mapping.id,
            "field_location": mapping.field_location,
            "db_field_name": mapping.db_field_name
        }
        for mapping in mappings
    ]
    return JsonResponse(data, safe=False)

def import_form(request, form_id, date):
    date = datetime.strptime(date, '%Y-%m-%d')  # Assuming date format is YYYY-MM-DD
    import_form_data(form_id, date)

    # Rest of your view logic

