from django.db import models
from PPA.models import IPP
class FormFormat(models.Model):
    IPP = models.ForeignKey(IPP, on_delete=models.CASCADE, related_name='forms')
    name = models.CharField(max_length=255)
    start_date = models.DateField()
    end_date = models.DateField()
    description = models.TextField(blank=True, null=True)
    file = models.CharField(max_length=255)  # Name of the file to be used as a template.
    sheet = models.CharField(max_length=25, null=True, default='[0]')  # Name of the sheet in the file to be used as a template.
    date_index_format = models.CharField(max_length=50)  # Format of the date in the column for indexing.
    date_location = models.CharField(max_length=50)  # 'Range' or 'Cell' or input 'date' to used function date
    time_index_format = models.CharField(max_length=50, null=True)  # Format of the date in the column for indexing.
    time_location = models.CharField(max_length=50, null=True)  # 'Range' or 'Cell'
    time_first_hour_offset = models.IntegerField(default=0)  # offset of first hour of day from 00:00:00
    mode = models.CharField(max_length=10, default='Search')  # 'Absolute' or 'Search'
    start_row = models.PositiveIntegerField(default=0)
    end_row = models.PositiveIntegerField(default=0)
    start_search = models.CharField(max_length=50, default='')  # String to search for in the column to identify the start of the data.
    end_search = models.CharField(max_length=50, default='')  # String to search for in the column to identify the end of the data.
    time_zone = models.CharField(max_length=25, default='America/Belize')  # Time zone of the data in the file.
    db_table_name = models.CharField(max_length=50)  # Name of the table in the database to which the form will map.

    class Meta:
        db_table = 'form_format'

    def __str__(self):
        return self.name

class FieldMapping(models.Model):
    form_format = models.ForeignKey(FormFormat, on_delete=models.CASCADE, related_name='field_mappings')
    field_location = models.CharField(max_length=50)  # To account for Excel sheets with AA, AB, etc.
    db_field_name = models.CharField(max_length=50)  # Name of the field in the table to which the column will map.
    index_field = models.BooleanField(default=False)  # Whether the field is used for indexing.
    operation = models.CharField(max_length=25, null=True)  # 'mathematical operations'
    class Meta:
        db_table = 'form_field_mapping'

    def __str__(self):
        return f"{self.form_format.name} - {self.db_field_name}"