import os
import django

# Set the DJANGO_SETTINGS_MODULE environment variable to your project's settings
os.environ.setdefault("DJANGO_SETTINGS_MODULE", "EMS.settings")
django.setup()

import calendar

from datetime import date, datetime, timedelta
from core.utils import fill_api_parameters, selenium_page_actions
from PPA.models import IPP, PPAData, Price, XUL115, PPA

def CFE_price():
    return 13

def obtain_cenace_mtrmta(start_date, end_date, proceso, ip="None"):
    api_endpoint = variables.objects.get(group='CFE_price', type='API', name='cenace').value
    api_param = variables.objects.get(group='CFE_price', type='parameters', name='cenace').value

    catalogs = ["08XUL-115"]  # Xulha
    if proceso == "MDA":
        end_date = end_date + timedelta(days=2)
    csvr = False

    n_date = start_date
    while n_date < end_date:
        e_date = min(n_date + timedelta(days=6), end_date)

        if proceso == "MTR":
            if n_date > date.today() - timedelta(days=7):
                if csvr:
                    break
                csvr = True
            if e_date > date.today() - timedelta(days=7):
                csvr = True
                e_date = date.today() - timedelta(days=7)

            if csvr:
                obtain_mtrcsv(date.today() - timedelta(days=6), date.today() - timedelta(days=3), catalogs[0], proceso)

        if check_cenace_date(n_date, e_date, catalogs[0], proceso):
            param_dict = {
                "proceso": proceso,
                "series": ",".join(catalogs),
                "start": n_date,
                "end": e_date,
            }
            url = api_endpoint + fill_api_parameters(api_param, param_dict)

            response = requests.get(url, proxies={"http": ip, "https": ip} if ip != "None" else None)

            data = response.json()  # parse the JSON data

            for zona_data in data["Resultados"]:
                for entry in zona_data["Valores"]:
                    defaults = {
                        'PML': entry['pml'],
                        'PML_ene': entry.get('pml_ene', None),
                        'PML_per': entry.get('pml_per', None),
                        'PML_cng': entry.get('pml_cng', None)
                    }

                    xul_instance, created = XUL115.objects.update_or_create(
                        PDate=entry['fecha'],  # or how the date is represented
                        hour=entry['hora'],
                        Proceso=proceso,
                        defaults=defaults
                    )

        n_date += timedelta(days=7)

    return 0

def get_cenace_csv(start, end):
    url_mtr = 'https://www.cenace.gob.mx/Paginas/SIM/Reportes/PreEnerServConMTR.aspx'
    url_mda = 'https://www.cenace.gob.mx/Paginas/SIM/Reportes/PreEnerServConMDA.aspx'
    start_date = (datetime.now() - timedelta(days=7)).strftime('%d/%m/%Y')
    if datetime.now().hour < 14:
        end_date = (datetime.now() - timedelta(days=4)).strftime('%d/%m/%Y')
    else:
        end_date = (datetime.now() - timedelta(days=3)).strftime('%d/%m/%Y')
    start_day, start_month, start_year = map(int, start_date.split('/'))
    end_day, end_month, end_year = map(int, end_date.split('/'))
    start_data_title = get_data_title_for_date(start_year, start_month, start_day)
    end_data_title = get_data_title_for_date(end_year, end_month, end_day)

    # Convert them to integers for comparison
    start_month = start_month - 1  # Because the options start from 0
    end_month = end_month - 1


    actions = [
        {
            "element_id": "ContentPlaceHolder1_txtPeriodo",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": ".drp-calendar.left select.monthselect",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": f".drp-calendar.left select.monthselect option[value='{start_month}']",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": ".drp-calendar.left select.yearselect",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": f".drp-calendar.left select.yearselect option[value='{start_year}']",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": ".drp-calendar.right select.monthselect",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": f".drp-calendar.right select.monthselect option[value='{end_month}']",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": ".drp-calendar.right select.yearselect",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": f".drp-calendar.right select.yearselect option[value='{end_year}']",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": f".drp-calendar.left tbody td[data-title='{start_data_title}']",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": f".drp-calendar.right tbody td[data-title='{end_data_title}']",
            "function": ["click"],
            "input": [None],
            "wait": [2]
        },
        {
            "element_css_selector": ".drp-buttons .applyBtn",
            "get_element_wait": 10,
            "function": ["execute_script", "execute_script"],
            "input": ["arguments[0].scrollIntoView(true);", "arguments[0].click();"],
            "wait": [2, 2]
        },
        {
            "element_id": "ContentPlaceHolder1_gvReportes_imgBtnCSV_0",
            "get_element_wait": 10,
            "function": ["execute_script", "execute_script"],
            "input": ["arguments[0].scrollIntoView(true);", "arguments[0].click();"],
            "wait": [2, 2]
        },
        {
            "element_id": "ContentPlaceHolder1_gvReportes_imgBtnCSV_1",
            "get_element_wait": 10,
            "function": ["execute_script", "execute_script"],
            "input": ["arguments[0].scrollIntoView(true);", "arguments[0].click();"],
            "wait": [2, 2]
        },
        {
            "element_id": "ContentPlaceHolder1_gvReportes_imgBtnCSV_2",
            "get_element_wait": 10,
            "function": ["execute_script", "execute_script"],
            "input": ["arguments[0].scrollIntoView(true);", "arguments[0].click();"],
            "wait": [2, 2]
        },
        {
            "element_id": "ContentPlaceHolder1_gvReportes_imgBtnCSV_3",
            "get_element_wait": 10,
            "function": ["execute_script", "execute_script"],
            "input": ["arguments[0].scrollIntoView(true);", "arguments[0].click();"],
            "wait": [2, 2]
        },
        {
            "element_id": "ContentPlaceHolder1_gvReportes_imgBtnCSV_4",
            "get_element_wait": 10,
            "function": ["execute_script", "execute_script"],
            "input": ["arguments[0].scrollIntoView(true);", "arguments[0].click();"],
            "wait": [2, 2]
        }
    ]
    selenium_page_actions(url_mtr, actions)


def get_data_title_for_date(year, month, day):
    # Get the first day of the month
    first_day = datetime(year, month, 1).weekday()

    # If the first day is Sunday, set the start row to 1, else 0
    start_row = 1 if first_day == 6 else 0  # 6 corresponds to Sunday

    # For determining the row: consider only the number of Sundays before the given day
    sundays_before_day = sum(1 for i in range(1, day + 1) if datetime(year, month, i).weekday() == 6)

    row = start_row + sundays_before_day - 1
    weekday_of_given_day = datetime(year, month, day).weekday()
    col = (weekday_of_given_day + 1) % 7

    return f"r{row}c{col}"

get_cenace_csv(1,1)