import requests
from django.db import models

class variables(models.Model):
    id = models.BigAutoField(primary_key=True)
    name = models.CharField(max_length=255)
    group = models.CharField(max_length=50)
    type = models.CharField(max_length=50)
    value = models.CharField(max_length=255)

    class Meta:
        db_table = 'variables'

    def __str__(self):
        return f"Generator {self.id} - {self.name}"

class URLRequest(models.Model):
    id = models.BigAutoField(primary_key=True)
    url = models.CharField(max_length=255)
    response = models.TextField()
    class Meta:
        db_table = 'url_request'

    def __str__(self):
        return f"URLRequest {self.id} - {self.url}"

    @classmethod
    def get_or_fetch_response(cls, url, headers=None):
        try:
            # Try to find an existing record with the given URL
            existing_record = cls.objects.get(url=url)
            return existing_record.response
        except cls.DoesNotExist:
            # If the record doesn't exist, fetch the response and create a new record
            response = requests.get(url, headers=headers)
            if response.status_code == 200:
                new_record = cls(url=url, response=response.text)
                new_record.save()
            else:
                print("Failed to retrieve the webpage.")

            return response.text

