import os
import django
from datetime import datetime, date, time, timedelta

# Set the DJANGO_SETTINGS_MODULE environment variable to your project's settings
os.environ.setdefault("DJANGO_SETTINGS_MODULE", "EMS.settings")
django.setup()

import cvxpy as cp

from django.conf import settings
from LF.utils import get_feeder_weather_forecast, get_feeder_load_forecasts
from Network.utils import get_minimized_network, get_generator_constraints
from PPA.utils import construct_price_matrix, convert_time_naive

def construct_horizon_matrices():
    now = datetime.now()
    start_date = datetime(now.year, now.month, now.day, now.hour)
    two_days_later = now + timedelta(days=2)
    end_date = datetime(two_days_later.year, two_days_later.month, two_days_later.day, 23, 0, 0)
    start_date_utc = convert_time_naive(start_date,  settings.TIME_ZONE, 'UTC')
    end_date_utc = convert_time_naive(end_date, settings.TIME_ZONE, 'UTC')
    start_date_utc = datetime(2023, 10, 27, 3, 0, 0)
    end_date_utc=datetime(2023, 10, 29, 5, 0, 0)

    bus_matrix, branch_matrix, gen_matrix = get_minimized_network()
    price_horizon = construct_price_matrix(start_date_utc, end_date_utc)
    weather_horizon = get_feeder_weather_forecast(start_date_utc, end_date_utc)
    loads_horizon = get_feeder_load_forecasts(start_date_utc, end_date_utc)


construct_horizon_matrices()

def solve_lagrangian(P, Q, node_matrix, branch_matrix, other_constraints):
    # Define variables
    # For this example, I'm assuming V (voltage magnitudes) and theta (voltage angles) are the main decision variables
    V = cp.Variable(node_matrix.shape[0])
    theta = cp.Variable(node_matrix.shape[0])

    # Define the objective function - typically the Lagrangian
    # Here's a simplified example. You'd adjust based on your exact Lagrangian formulation
    objective = cp.Minimize(cp.sum_squares(P * V) + cp.sum_squares(Q * theta))

    # Define constraints
    constraints = [
        # Power balance constraints, voltage constraints, etc.
        # For example:
        node_matrix * V <= other_constraints['node_max'],
        branch_matrix * theta <= other_constraints['branch_max'],
        # Add other constraints here
    ]

    # Formulate the problem
    problem = cp.Problem(objective, constraints)

    # Solve the problem
    problem.solve()

    # Return the optimized values of V and theta
    return V.value, theta.value


