from django.db import models

# Create your models here.
class IPP(models.Model):
    id = models.IntegerField(primary_key=True)
    code = models.CharField(max_length=3)
    name = models.CharField(max_length=50)
    location = models.CharField(max_length=255)
    class Meta:
        db_table = 'IPP'

class PPA(models.Model):
    id = models.BigIntegerField(primary_key=True)
    name = models.CharField(max_length=50)
    IPP_id = models.IntegerField()
    start_date = models.DateTimeField()
    end_date = models.DateTimeField()
    pricing_type = models.CharField(max_length=10)
    energy_price = models.FloatField(null=True) # $/MWh
    energy_price_cur = models.CharField(max_length=3, null=True) # Currency of energy price BZD or USD
    energy_price_fxn = models.CharField(max_length=50, null=True)
    fuel_cost_fxn = models.CharField(max_length=50, null=True)
    fuel_name = models.CharField(max_length=50, null=True)
    available_fuel_vol = models.FloatField(null=True)
    available_fuel_ene = models.FloatField(null=True)
    available_fuel_fxn = models.CharField(max_length=50, null=True)
    strategic_price = models.FloatField(null=True)
    strategic_price_fxn = models.CharField(max_length=50, null=True)
    threshold_condition = models.CharField(max_length=50, null=True)

    class Meta:
        db_table = 'PPA'

class PPAGenerator(models.Model):
    id = models.BigAutoField (primary_key=True)
    PPA_id = models.BigIntegerField()
    etap_iid = models.BigIntegerField()
    type = models.CharField(max_length=10)
    etap_id = models.CharField(max_length=100)
    bus_iid = models.BigIntegerField(null=True)
    IPP = models.CharField(max_length=5, null=True)
    PPA_id = models.IntegerField(null=True)
    index = models.IntegerField(null=True)
    must_run = models.BooleanField(default=False)
    must_run_condition = models.CharField(max_length=255, null=True)
    # fuel cost curve output in $ as function of x(MW) and p($/gal)
    fuel_cost_curve = models.CharField(max_length=255, null=True)
    P_max = models.FloatField(null=True)
    P_min = models.FloatField(null=True)
    Q_max = models.FloatField(null=True)
    Q_min = models.FloatField(null=True)
    status = models.BooleanField(null=True, default=True) #Online or Offline
    ramp_up = models.FloatField(null=True)  # MW/min
    ramp_down = models.FloatField(null=True)  # MW/min
    start_up_cost = models.FloatField(null=True)  # $
    min_up_time = models.IntegerField(null=True)  # min
    min_down_time = models.IntegerField(null=True)  # min
    shut_down_cost = models.FloatField(null=True)  # $

    class Meta:
        db_table = 'PPA_generator'

class PPAData(models.Model):
    id = models.IntegerField(primary_key=True)
    PPA_id = models.IntegerField()
    time = models.DateTimeField()
    attribute = models.CharField(max_length=255)
    value = models.CharField(max_length=255)
    meta = models.CharField(max_length=255)
    class Meta:
        db_table = 'PPA_Data'

class Price(models.Model):
    item_price = models.FloatField(null=True)
    item_name = models.CharField(primary_key=True, max_length=255)
    uom = models.CharField(max_length=255)
    item_code = models.CharField(max_length=255)
    class Meta:
        db_table = 'price'

class XUL115(models.Model):
    id = models.BigAutoField(primary_key=True)
    time = models.DateTimeField() # formatted as UTC
    Proceso = models.CharField(max_length=10)
    PML = models.FloatField() # USD/MWh
    PML_ene = models.FloatField(null=True) # USD/MWh
    PML_per = models.FloatField(null=True) # USD/MWh
    PML_cng = models.FloatField(null=True) # USD/MWh
    class Meta:
        db_table = 'XUL115'

class Rates(models.Model):
    id = models.BigAutoField(primary_key=True)
    PPA_id = models.IntegerField()
    time = models.DateTimeField() # formatted as UTC
    type = models.CharField(max_length=20)
    rate = models.FloatField()
    currency = models.CharField(max_length=3)
    class Meta:
        db_table = 'rates'
