from django.shortcuts import render, redirect
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from .models import UploadedFile
from .forms import UploadFileForm
from .utils import parse_xml_and_save, populate_network_from_components, get_islands, \
                    return_network_graph, save_positions_to_node, update_component_status

def upload_file(request):
    if request.method == 'POST':
        form = UploadFileForm(request.POST, request.FILES)
        if form.is_valid():
            # Pre-fill the 'user' field with the current user and make it non-editable
            form.instance.user = request.META.get('USERNAME', '')
            form.save()
            return redirect('upload_success')
    else:
        initial_data = {'user': request.user.username} if request.user.is_authenticated else {}
        form = UploadFileForm(initial=initial_data)
        json_data = return_network_graph()
    return render(request, 'upload.html', {'form': form, 'json_data': json_data})

def view_network_min(request):
    json_data = return_network_graph(True)
    return render(request, 'view_minimized_network.html', {'json_data': json_data})

def upload_success(request):
    return render(request, 'upload_success.html')

def extract_components(request):
    # Call parse_xml_and_save() function
    parse_xml_and_save()
    return JsonResponse({'message': 'Components extracted successfully'})

def build_network(request):
    # Call populate_network_from_components() function
    populate_network_from_components()
    return JsonResponse({'message': 'Network built successfully'})

def save_positions(request):
    if request.method == 'POST':
        return save_positions_to_node(request)
    else:
        # Handle the case for non-POST requests
        return JsonResponse({'status': 'error', 'message': 'Only POST method is allowed'})

@csrf_exempt
def update_switch_status(request, switch_id):
    if request.method == 'POST':
        return update_component_status(switch_id)
    else:
        # Handle the case for non-POST requests
        return JsonResponse({'status': 'error', 'message': 'Only POST method is allowed'})