from django.db import models
# voltage is in kV
# power is in MW and MVAR
# resistance is in ohm
# reactance is in ohm
# current is in A

class Generator(models.Model):
    id = models.BigAutoField(primary_key=True)
    type = models.CharField(max_length=25)
    etap_id = models.CharField(max_length=50, null=True)
    etap_iid = models.BigIntegerField(null=True)
    etap_GUID = models.CharField(max_length=255, null=True)
    etap_LocX = models.BigIntegerField(null=True)
    etap_LocY = models.BigIntegerField(null=True)
    P_min = models.FloatField(null=True) #MW
    P_max = models.FloatField(null=True) #MW
    Q_max = models.FloatField(null=True) #MVAR
    Q_min = models.FloatField(null=True) #MVAR
    op_voltage = models.FloatField(null=True)
    bus_iid = models.BigIntegerField(null=True)

    class Meta:
        db_table = 'generator'
        indexes = [
            models.Index(fields=['bus_iid']),
        ]
    def __str__(self):
        return f"Generator {self.id} - {self.type}"
class Transformer(models.Model):
    id = models.BigAutoField(primary_key=True)
    type = models.CharField(max_length=25)
    etap_id = models.CharField(max_length=50, null=True)
    etap_iid = models.BigIntegerField(null=True)
    etap_GUID = models.CharField(max_length=255, null=True)
    etap_LocX = models.BigIntegerField(null=True)
    etap_LocY = models.BigIntegerField(null=True)
    MaxS = models.FloatField(null=True)
    S = models.FloatField(null=True)
    efficiency = models.FloatField(null=True)
    primary_V = models.FloatField(null=True)
    primary_type = models.CharField(max_length=5, null=True)
    primary_ground = models.IntegerField(null=True)
    primary_S = models.FloatField(null=True)
    primary_bus_iid = models.BigIntegerField(null=True)
    secondary_V = models.FloatField(null=True)
    secondary_type = models.CharField(max_length=5, null=True)
    secondary_ground = models.IntegerField(null=True)
    secondary_S = models.FloatField(null=True)
    secondary_bus_iid = models.BigIntegerField(null=True)
    tertiary_V = models.FloatField(null=True)
    tertiary_type = models.CharField(max_length=5, null=True)
    tertiary_ground = models.IntegerField(null=True)
    tertiary_S = models.FloatField(null=True)
    tertiary_bus_iid = models.BigIntegerField(null=True)

    class Meta:
        db_table = 'transformer'
        indexes = [
            models.Index(fields=['primary_bus_iid']),
            models.Index(fields=['secondary_bus_iid']),
            models.Index(fields=['tertiary_bus_iid']),
        ]

class Conductor(models.Model):
    id = models.BigAutoField(primary_key=True)
    type = models.CharField(max_length=25)
    etap_id = models.CharField(max_length=50, null=True)
    etap_iid = models.BigIntegerField(null=True)
    etap_GUID = models.CharField(max_length=255, null=True)
    etap_LocX = models.BigIntegerField(null=True)
    etap_LocY = models.BigIntegerField(null=True)
    from_bus_iid = models.BigIntegerField(null=True)
    to_bus_iid = models.BigIntegerField(null=True)
    length = models.FloatField(null=True)
    length_unit = models.CharField(max_length=5)
    R_pos = models.FloatField(null=True)
    R_zero = models.FloatField(null=True)
    C_pos = models.FloatField(null=True)
    C_zero = models.FloatField(null=True)
    L_pos = models.FloatField(null=True)
    L_zero = models.FloatField(null=True)
    current_limit = models.FloatField(null=True)

    class Meta:
        db_table = 'conductor'
        indexes = [
            models.Index(fields=['from_bus_iid']),
            models.Index(fields=['to_bus_iid']),
        ]

class Switch(models.Model):
    id = models.BigAutoField(primary_key=True)
    type = models.CharField(max_length=25)
    etap_id = models.CharField(max_length=50, null=True)
    etap_iid = models.BigIntegerField(null=True)
    etap_GUID = models.CharField(max_length=255, null=True)
    etap_LocX = models.BigIntegerField(null=True)
    etap_LocY = models.BigIntegerField(null=True)
    from_bus_iid = models.BigIntegerField(null=True)
    to_bus_iid = models.BigIntegerField(null=True)
    to_bus_iid_2 = models.BigIntegerField(null=True)  # used by Double Switch
    status = models.CharField(max_length=10, null=True)
    class Meta:
        db_table = 'switch'
        indexes = [
            models.Index(fields=['from_bus_iid']),
            models.Index(fields=['to_bus_iid']),
            models.Index(fields=['to_bus_iid_2']),
        ]
class ComponentAttributes(models.Model):
        id = models.BigAutoField(primary_key=True)
        table = models.CharField(max_length=50)
        field = models.CharField(max_length=50)
        component = models.CharField(max_length=100)
        attribute = models.CharField(max_length=50, null=True)
        operation = models.CharField(max_length=50, null=True)
        class Meta:
            db_table = 'component_attributes'
class Connection(models.Model):
    FromElement = models.CharField(max_length=20, null=True)
    FromID = models.CharField(max_length=40, null=True)
    FromIID = models.BigIntegerField(null=True)
    FromPin = models.IntegerField(null=True)

    ToElement = models.CharField(max_length=20, null=True)
    ToID = models.CharField(max_length=40, null=True)
    ToIID = models.BigIntegerField(null=True)
    ToPin = models.IntegerField(null=True)
    class Meta:
        db_table = 'connection'

class UploadedFile(models.Model):
    user = models.CharField(max_length=50)
    file = models.FileField(upload_to='uploads/')
    uploaded_at = models.DateTimeField(auto_now_add=True)
    type = models.CharField(max_length=25,null=True)
    class Meta:
        db_table = 'uploadedfile'
class Bus(models.Model):
    id = models.BigAutoField(primary_key=True)
    type = models.CharField(max_length=25)
    op_voltage = models.FloatField(null=True)
    etap_id = models.CharField(max_length=50, null=True)
    etap_iid = models.BigIntegerField(null=True)
    etap_GUID = models.CharField(max_length=255, null=True)
    etap_LocX = models.BigIntegerField(null=True)
    etap_LocY = models.BigIntegerField(null=True)

    class Meta:
        db_table = 'bus'

class Capacitor(models.Model):
    id = models.BigAutoField(primary_key=True)
    type = models.CharField(max_length=25)
    etap_id = models.CharField(max_length=50, null=True)
    etap_iid = models.BigIntegerField(null=True)
    etap_GUID = models.CharField(max_length=255, null=True)
    etap_LocX = models.BigIntegerField(null=True)
    etap_LocY = models.BigIntegerField(null=True)
    bank_number = models.IntegerField(null=True)
    Q_per_bank = models.FloatField(null=True)
    Q = models.FloatField(null=True)
    op_voltage = models.FloatField(null=True)
    bus_iid = models.BigIntegerField(null=True)
    switch_in_Q = models.FloatField(null=True)
    switch_out_Q = models.FloatField(null=True)
    switch_in_V = models.FloatField(null=True)
    switch_out_V = models.FloatField(null=True)
    switch_in_A = models.FloatField(null=True)
    switch_out_A = models.FloatField(null=True)

    class Meta:
        db_table = 'capacitor'
        indexes = [
            models.Index(fields=['bus_iid']),
        ]

class LoadEtap(models.Model):
    id = models.BigAutoField(primary_key=True)
    type = models.CharField(max_length=25)
    op_voltage = models.FloatField(null=True)
    etap_id = models.CharField(max_length=50, null=True)
    etap_iid = models.BigIntegerField(null=True)
    etap_GUID = models.CharField(max_length=255, null=True)
    etap_LocX = models.BigIntegerField(null=True)
    etap_LocY = models.BigIntegerField(null=True)
    S = models.FloatField(null=True)
    Q = models.FloatField(null=True)
    P = models.FloatField(null=True)
    PF = models.FloatField(null=True)
    bus_iid = models.BigIntegerField(null=True)

    class Meta:
        db_table = 'load_etap'
        indexes = [
            models.Index(fields=['bus_iid']),
        ]

class Island(models.Model):
    id = models.BigAutoField(primary_key=True)
    name = models.CharField(max_length=100)
    nodes = models.BigIntegerField(null=True)
    edges = models.BigIntegerField(null=True)
    class Meta:
        db_table = 'island'

class Node(models.Model):
    id = models.BigAutoField(primary_key=True)
    island = models.ForeignKey(Island, on_delete=models.CASCADE, null=True)
    bus_id = models.PositiveIntegerField()
    bus_etap_iid = models.BigIntegerField(null=True)
    loads_lumped = models.IntegerField(null=True)
    loads_single = models.IntegerField(null=True)
    loads_feeder = models.IntegerField(null=True)
    capacitors = models.IntegerField(null=True)
    generators = models.IntegerField(null=True)
    reference_voltage = models.FloatField(null=True)
    voltage_phase_A = models.FloatField(null=True)
    voltage_phase_B = models.FloatField(null=True)
    voltage_phase_C = models.FloatField(null=True)
    user_LocX = models.BigIntegerField(null=True)
    user_LocY = models.BigIntegerField(null=True)
    type = models.CharField(max_length=25, null=True)
    loads_string = models.TextField(null=True)
    generators_string = models.TextField(null=True)
    capacitors_string = models.TextField(null=True)
    transformers_string = models.TextField(null=True)
    switches_string = models.TextField(null=True)
    voltage_string = models.TextField(null=True)
    etap_id = models.CharField(max_length=50, null=True)
    layer = models.CharField(max_length=20, null=True)
    status = models.CharField(max_length=10, null=True)

    class Meta:
        db_table = 'node'
    def __str__(self):
        return f"{self.etap_id}"

class Edge(models.Model):
    island = models.ForeignKey(Island, on_delete=models.CASCADE, null=True)
    # from_node is always the smaller IID of the two nodes
    from_node = models.ForeignKey(Node, related_name='outgoing_edges', on_delete=models.CASCADE)
    to_node = models.ForeignKey(Node, related_name='incoming_edges', on_delete=models.CASCADE)
    from_bus_iid = models.BigIntegerField(null=True)
    to_bus_iid = models.BigIntegerField(null=True)
    transformers = models.IntegerField(null=True)
    switches = models.IntegerField(null=True)
    threeWinding = models.IntegerField(null=True)
    transformer_ratio = models.FloatField(null=True)
    conductors = models.IntegerField(null=True)
    R_pos = models.FloatField(null=True)
    R_zero = models.FloatField(null=True)
    C_pos = models.FloatField(null=True)
    C_zero = models.FloatField(null=True)
    L_pos = models.FloatField(null=True)
    L_zero = models.FloatField(null=True)
    current_limit = models.FloatField(null=True)
    voltage_ratio = models.FloatField(null=True, default=0)
    voltage_shift = models.FloatField(null=True, default=0)
    status = models.CharField(max_length=10, null=True)
    high_side = models.BigIntegerField(null=True)
    transformers_string = models.TextField(null=True)
    conductors_string = models.TextField(null=True)
    layer = models.CharField(max_length=20, null=True)

    class Meta:
        db_table = 'edge'
    def __str__(self):
        return f"{self.from_node.etap_id} -> {self.to_node.etap_id}"

class Label(models.Model):
    id = models.BigAutoField(primary_key=True)
    label = models.CharField(max_length=100)
    user_LocX = models.BigIntegerField(null=True)
    user_LocY = models.BigIntegerField(null=True)
    class Meta:
        db_table = 'label'

class NodeMin(models.Model):
    id = models.BigAutoField(primary_key=True)
    island_id = models.BigIntegerField(null=True)
    bus_id = models.PositiveIntegerField()
    bus_etap_iid = models.BigIntegerField(null=True)
    loads_lumped = models.IntegerField(null=True)
    loads_single = models.IntegerField(null=True)
    loads_feeder = models.IntegerField(null=True)
    capacitors = models.IntegerField(null=True)
    generators = models.IntegerField(null=True)
    reference_voltage = models.FloatField(null=True)
    voltage_phase_A = models.FloatField(null=True)
    voltage_phase_B = models.FloatField(null=True)
    voltage_phase_C = models.FloatField(null=True)
    user_LocX = models.BigIntegerField(null=True)
    user_LocY = models.BigIntegerField(null=True)
    type = models.CharField(max_length=25, null=True)
    loads_string = models.TextField(null=True)
    generators_string = models.TextField(null=True)
    capacitors_string = models.TextField(null=True)
    transformers_string = models.TextField(null=True)
    switches_string = models.TextField(null=True)
    voltage_string = models.TextField(null=True)
    etap_id = models.CharField(max_length=50, null=True)
    layer = models.CharField(max_length=20, null=True)
    status = models.CharField(max_length=10, null=True)

    class Meta:
        db_table = 'node_min'
    def __str__(self):
        return f"{self.etap_id}"

class EdgeMin(models.Model):
    id = models.BigAutoField(primary_key=True)
    island_id = models.BigIntegerField(null=True)
    # from_node is always the smaller IID of the two nodes
    from_node = models.ForeignKey(NodeMin, related_name='outgoing_edges', on_delete=models.CASCADE)
    to_node = models.ForeignKey(NodeMin, related_name='incoming_edges', on_delete=models.CASCADE)
    from_bus_iid = models.BigIntegerField(null=True)
    to_bus_iid = models.BigIntegerField(null=True)
    transformers = models.IntegerField(null=True)
    switches = models.IntegerField(null=True)
    threeWinding = models.IntegerField(null=True)
    transformer_ratio = models.FloatField(null=True)
    conductors = models.IntegerField(null=True)
    R_pos = models.FloatField(null=True)
    R_zero = models.FloatField(null=True)
    C_pos = models.FloatField(null=True)
    C_zero = models.FloatField(null=True)
    L_pos = models.FloatField(null=True)
    L_zero = models.FloatField(null=True)
    current_limit = models.FloatField(null=True)
    voltage_ratio = models.FloatField(null=True, default=0)
    voltage_shift = models.FloatField(null=True, default=0)
    status = models.CharField(max_length=10, null=True)
    high_side = models.BigIntegerField(null=True)
    transformers_string = models.TextField(null=True)
    conductors_string = models.TextField(null=True)
    layer = models.CharField(max_length=20, null=True)

    class Meta:
        db_table = 'edge_min'
    def __str__(self):
        return f"{self.from_node.etap_id} -> {self.to_node.etap_id}"
