# Generated by Django 4.2.5 on 2023-09-14 22:47

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Bus',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=25)),
                ('op_voltage', models.FloatField(null=True)),
                ('etap_id', models.CharField(max_length=50, null=True)),
                ('etap_iid', models.BigIntegerField(null=True)),
                ('etap_GUID', models.CharField(max_length=255, null=True)),
                ('etap_LocX', models.BigIntegerField(null=True)),
                ('etap_LocY', models.BigIntegerField(null=True)),
            ],
            options={
                'db_table': 'bus',
            },
        ),
        migrations.CreateModel(
            name='ComponentAttributes',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('table', models.CharField(max_length=50)),
                ('field', models.CharField(max_length=50)),
                ('component', models.CharField(max_length=100)),
                ('attribute', models.CharField(max_length=50, null=True)),
                ('operation', models.CharField(max_length=50, null=True)),
            ],
            options={
                'db_table': 'component_attributes',
            },
        ),
        migrations.CreateModel(
            name='Connection',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('FromElement', models.CharField(max_length=20, null=True)),
                ('FromID', models.CharField(max_length=20, null=True)),
                ('FromIID', models.BigIntegerField(null=True)),
                ('FromPin', models.IntegerField(null=True)),
                ('ToElement', models.CharField(max_length=20, null=True)),
                ('ToID', models.CharField(max_length=20, null=True)),
                ('ToIID', models.BigIntegerField(null=True)),
                ('ToPin', models.IntegerField(null=True)),
            ],
            options={
                'db_table': 'connection',
            },
        ),
        migrations.CreateModel(
            name='Island',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('nodes', models.BigIntegerField(null=True)),
                ('edges', models.BigIntegerField(null=True)),
            ],
            options={
                'db_table': 'island',
            },
        ),
        migrations.CreateModel(
            name='UploadedFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.CharField(max_length=50)),
                ('file', models.FileField(upload_to='uploads/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('type', models.CharField(max_length=25, null=True)),
            ],
            options={
                'db_table': 'uploadedfile',
            },
        ),
        migrations.CreateModel(
            name='Transformer',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=25)),
                ('etap_id', models.CharField(max_length=50, null=True)),
                ('etap_iid', models.BigIntegerField(null=True)),
                ('etap_GUID', models.CharField(max_length=255, null=True)),
                ('etap_LocX', models.BigIntegerField(null=True)),
                ('etap_LocY', models.BigIntegerField(null=True)),
                ('MaxS', models.FloatField(null=True)),
                ('S', models.FloatField(null=True)),
                ('efficiency', models.FloatField(null=True)),
                ('primary_V', models.FloatField(null=True)),
                ('primary_type', models.CharField(max_length=5, null=True)),
                ('primary_ground', models.IntegerField(null=True)),
                ('primary_S', models.FloatField(null=True)),
                ('primary_bus_iid', models.BigIntegerField(null=True)),
                ('secondary_V', models.FloatField(null=True)),
                ('secondary_type', models.CharField(max_length=5, null=True)),
                ('secondary_ground', models.IntegerField(null=True)),
                ('secondary_S', models.FloatField(null=True)),
                ('secondary_bus_iid', models.BigIntegerField(null=True)),
                ('tertiary_V', models.FloatField(null=True)),
                ('tertiary_type', models.CharField(max_length=5, null=True)),
                ('tertiary_ground', models.IntegerField(null=True)),
                ('tertiary_S', models.FloatField(null=True)),
                ('tertiary_bus_iid', models.BigIntegerField(null=True)),
            ],
            options={
                'db_table': 'transformer',
                'indexes': [models.Index(fields=['primary_bus_iid'], name='transformer_primary_f4c433_idx'), models.Index(fields=['secondary_bus_iid'], name='transformer_seconda_a339e5_idx'), models.Index(fields=['tertiary_bus_iid'], name='transformer_tertiar_e4c264_idx')],
            },
        ),
        migrations.CreateModel(
            name='Node',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('bus_id', models.PositiveIntegerField()),
                ('bus_etap_iid', models.BigIntegerField(null=True)),
                ('loads', models.IntegerField(null=True)),
                ('capacitors', models.IntegerField(null=True)),
                ('generators', models.IntegerField(null=True)),
                ('voltage_phase_A', models.FloatField(null=True)),
                ('voltage_phase_B', models.FloatField(null=True)),
                ('voltage_phase_C', models.FloatField(null=True)),
                ('island', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='Network.island')),
            ],
            options={
                'db_table': 'node',
            },
        ),
        migrations.CreateModel(
            name='LoadEtap',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=25)),
                ('op_voltage', models.FloatField(null=True)),
                ('etap_id', models.CharField(max_length=50, null=True)),
                ('etap_iid', models.BigIntegerField(null=True)),
                ('etap_GUID', models.CharField(max_length=255, null=True)),
                ('etap_LocX', models.BigIntegerField(null=True)),
                ('etap_LocY', models.BigIntegerField(null=True)),
                ('S', models.FloatField(null=True)),
                ('Q', models.FloatField(null=True)),
                ('P', models.FloatField(null=True)),
                ('PF', models.FloatField(null=True)),
                ('bus_iid', models.BigIntegerField(null=True)),
            ],
            options={
                'db_table': 'load_etap',
                'indexes': [models.Index(fields=['bus_iid'], name='load_etap_bus_iid_51b362_idx')],
            },
        ),
        migrations.CreateModel(
            name='Generator',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=25)),
                ('IPP', models.CharField(max_length=5, null=True)),
                ('PPA_id', models.IntegerField()),
                ('index', models.IntegerField(null=True)),
                ('must_run', models.BooleanField(default=False)),
                ('must_run_condition', models.CharField(max_length=255, null=True)),
                ('fuel_cost_curve', models.BigIntegerField(null=True)),
                ('run_status', models.CharField(max_length=10, null=True)),
                ('etap_id', models.CharField(max_length=50, null=True)),
                ('etap_iid', models.BigIntegerField(null=True)),
                ('etap_GUID', models.CharField(max_length=255, null=True)),
                ('etap_LocX', models.BigIntegerField(null=True)),
                ('etap_LocY', models.BigIntegerField(null=True)),
                ('P_min', models.FloatField(null=True)),
                ('P_max', models.FloatField(null=True)),
                ('Q_max', models.FloatField(null=True)),
                ('Q_min', models.FloatField(null=True)),
                ('op_voltage', models.FloatField(null=True)),
                ('typical_profile', models.CharField(max_length=255, null=True)),
                ('current_profile', models.CharField(max_length=255, null=True)),
                ('bus_iid', models.BigIntegerField(null=True)),
            ],
            options={
                'db_table': 'generator',
                'indexes': [models.Index(fields=['bus_iid'], name='generator_bus_iid_e4e509_idx')],
            },
        ),
        migrations.CreateModel(
            name='Edge',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_bus_iid', models.BigIntegerField(null=True)),
                ('to_bus_iid', models.BigIntegerField(null=True)),
                ('transformers', models.IntegerField(null=True)),
                ('conductors', models.IntegerField(null=True)),
                ('R', models.FloatField(null=True)),
                ('Z', models.FloatField(null=True)),
                ('voltage_ratio', models.FloatField(default=0, null=True)),
                ('voltage_shift', models.FloatField(default=0, null=True)),
                ('from_node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='outgoing_edges', to='Network.node')),
                ('island', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='Network.island')),
                ('to_node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='incoming_edges', to='Network.node')),
            ],
            options={
                'db_table': 'edge',
            },
        ),
        migrations.CreateModel(
            name='Conductor',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=25)),
                ('etap_id', models.CharField(max_length=50, null=True)),
                ('etap_iid', models.BigIntegerField(null=True)),
                ('etap_GUID', models.CharField(max_length=255, null=True)),
                ('etap_LocX', models.BigIntegerField(null=True)),
                ('etap_LocY', models.BigIntegerField(null=True)),
                ('from_bus_iid', models.BigIntegerField(null=True)),
                ('to_bus_iid', models.BigIntegerField(null=True)),
                ('length', models.FloatField(null=True)),
                ('length_unit', models.CharField(max_length=5)),
                ('R_pos', models.FloatField(null=True)),
                ('R_zero', models.FloatField(null=True)),
                ('C_pos', models.FloatField(null=True)),
                ('C_zero', models.FloatField(null=True)),
                ('L_pos', models.FloatField(null=True)),
                ('L_zero', models.FloatField(null=True)),
                ('current_limit', models.FloatField(null=True)),
            ],
            options={
                'db_table': 'conductor',
                'indexes': [models.Index(fields=['from_bus_iid'], name='conductor_from_bu_f9cc85_idx'), models.Index(fields=['to_bus_iid'], name='conductor_to_bus__c427b5_idx')],
            },
        ),
        migrations.CreateModel(
            name='Capacitor',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('type', models.CharField(max_length=25)),
                ('etap_id', models.CharField(max_length=50, null=True)),
                ('etap_iid', models.BigIntegerField(null=True)),
                ('etap_GUID', models.CharField(max_length=255, null=True)),
                ('etap_LocX', models.BigIntegerField(null=True)),
                ('etap_LocY', models.BigIntegerField(null=True)),
                ('bank_number', models.IntegerField(null=True)),
                ('Q_per_bank', models.FloatField(null=True)),
                ('Q', models.FloatField(null=True)),
                ('op_voltage', models.FloatField(null=True)),
                ('bus_iid', models.BigIntegerField(null=True)),
                ('switch_in_Q', models.FloatField(null=True)),
                ('switch_out_Q', models.FloatField(null=True)),
                ('switch_in_V', models.FloatField(null=True)),
                ('switch_out_V', models.FloatField(null=True)),
                ('switch_in_A', models.FloatField(null=True)),
                ('switch_out_A', models.FloatField(null=True)),
            ],
            options={
                'db_table': 'capacitor',
                'indexes': [models.Index(fields=['bus_iid'], name='capacitor_bus_iid_ae06f0_idx')],
            },
        ),
    ]
