from django import forms
from .models import UploadedFile

class UploadFileForm(forms.ModelForm):
    class Meta:
        model = UploadedFile
        fields = ('user', 'file')

        def __init__(self, *args, **kwargs):
            super().__init__(*args, **kwargs)
            # Set 'user' field as hidden input
            self.fields['user'].widget = forms.HiddenInput()