from django.shortcuts import render, redirect
from django.http import JsonResponse
from django.utils.dateparse import parse_datetime
from django.conf import settings
from django.urls import reverse
from pytz import timezone
from dateutil.relativedelta import relativedelta
from datetime import datetime


from .utils import feeder_spatial_join, get_feeder_nearest_ws, train_feeder_models_LF, \
    pd_to_context, get_weather_and_load, get_historical_weather

def spatial_join(request):
    feeder_spatial_join()
    return JsonResponse({'message': 'Network built successfully'})

def view_weather_load(request):
    # Get the start and end time from the request URL
    starttime = request.GET.get('starttime')
    endtime = request.GET.get('endtime')

    # Convert the times to datetime objects
    start_dt = parse_datetime(starttime)
    end_dt = parse_datetime(endtime)

    # Convert the times to UTC
    local_tz = timezone(settings.TIME_ZONE)
    utc = timezone('UTC')

    start_dt = local_tz.localize(start_dt).astimezone(utc)
    end_dt = local_tz.localize(end_dt).astimezone(utc)

    data = get_weather_and_load(start_dt, end_dt)
    return JsonResponse(data, safe=False)

def display_load_forcast(request, starttime=None, endtime=None):
    # If start_date or end_date are not provided, set them to the last month
    if not starttime or not endtime:
        local_tz = timezone(settings.TIME_ZONE)
        now = datetime.now(local_tz)
        endtime = now.strftime("%Y-%m-%dT%H:%M:%S")
        starttime = (now - relativedelta(days=7)).strftime("%Y-%m-%dT%H:%M:%S")

        # Redirect to the URL with the default start and end dates added
        return redirect(reverse('load_forecast', args=[starttime, endtime]))

    feeders_with_stations = get_feeder_nearest_ws()
    # Return the result as a list of dictionaries
    context = {
        'results': pd_to_context(feeders_with_stations),
    }
    return render(request, 'Load_forecast.html', context)

def train_feeder_models(request):
    starttime = '2018-07-01T12:55:44'
    endtime = '2018-09-30T12:55:44'

    # Convert the times to datetime objects
    start_dt = parse_datetime(starttime)
    end_dt = parse_datetime(endtime)

    # Convert the times to UTC
    local_tz = timezone(settings.TIME_ZONE)
    utc = timezone('UTC')

    start_dt = local_tz.localize(start_dt).astimezone(utc)
    end_dt = local_tz.localize(end_dt).astimezone(utc)

    train_feeder_models_LF(start_dt, end_dt)
    return JsonResponse({'message': 'Feeder Models have been trained'})

def get_historical(request):

    # Convert the times to datetime objects
    start_dt = datetime(2017, 3, 31).replace(second=0, microsecond=0, minute=0)
    end_dt = datetime.now().replace(second=0, microsecond=0, minute=0)

    start_dt = start_dt.replace(tzinfo=None)
    end_dt = end_dt.replace(tzinfo=None)

    get_historical_weather(start_dt, end_dt)
    return JsonResponse({'message': 'Feeder Models have been trained'})
