from django.db import models
import pickle

# Create your models here.
class Weather(models.Model):
    # nms data is time naive. when running utils.summarize_weather_by_hour,
    # the time is corrected to UTC. if importing from csv, need to add 6 hours
    # to the time
    time = models.DateTimeField()
    weather_station_id = models.IntegerField()
    temperature = models.FloatField(null=True) #deg C
    humidity = models.FloatField(null=True) #%
    irradiance = models.FloatField(null=True) #W/m^2
    windspeed = models.FloatField(null=True) #knots
    winddirection = models.FloatField(null=True) #deg
    rainfall = models.FloatField(null=True) #mm
    riverlevel = models.FloatField(null=True) #m

    class Meta:
        db_table = 'weather'
        indexes = [
            models.Index(fields=['time']),
        ]
    def __str__(self):
        return f"WeatherMinute {self.id} - {self.load_identifier}"


class WeatherTest(models.Model):
    time = models.DateTimeField(db_index=True)
    weather_station_id = models.IntegerField()
    temperature = models.FloatField(null=True)
    humidity = models.FloatField(null=True)
    irradiance = models.FloatField(null=True)
    windspeed = models.FloatField(null=True)
    winddirection = models.FloatField(null=True)
    rainfall = models.FloatField(null=True)
    riverlevel = models.FloatField(null=True)
    class Meta:
        db_table = 'weather_test'
        indexes = [
            models.Index(fields=['time']),
        ]
    def __str__(self):
        return f"WeatherMinute {self.id} - {self.load_identifier}"


class Load(models.Model):
    # BEL excel data is time naive. need to add 6 hours to the time
    # when importing from csv
    time = models.DateTimeField(null=False)
    type = models.CharField(max_length=25,null=True)
    feeder_id = models.IntegerField(null=True)
    P = models.FloatField(null=True)
    Q = models.FloatField(null=True)
    P_forecast = models.FloatField(null=True)
    Q_forecast = models.FloatField(null=True)
    V_AB = models.FloatField(null=True)
    V_BC = models.FloatField(null=True)
    V_AC = models.FloatField(null=True)
    class Meta:
        db_table = 'load'
        indexes = [
            models.Index(fields=['time']),
        ]
    def __str__(self):
        return f"LoadMinute {self.time} - {self.load_identifier}"

class Feeder(models.Model):
    id=models.IntegerField(primary_key=True)
    load_identifier = models.CharField(max_length=10, null=True)
    PrimaryBreaker = models.CharField(max_length=20, null=True)
    FeederName = models.CharField(max_length=20, null=True)
    etap_iid = models.BigIntegerField(null=True)
    Shape = models.TextField(null=True)
    # this field will store the serialized tensorflow model
    trained_model = models.BinaryField(null=True, blank=True)
    trained_start = models.DateTimeField(null=True, blank=True)
    trained_end = models.DateTimeField(null=True, blank=True)
    trained_id = models.IntegerField(null=True, blank=True)
    trained_records = models.IntegerField(null=True, blank=True)
    trained_features = models.CharField(max_length=255, null=True, blank=True)
    load_typical = models.FloatField(null=True, blank=True)
    prediction_type = models.CharField(max_length=15, null=True)
    load_profile = models.TextField(null=True)
    weather_station_id = models.IntegerField(null=True)
    distance = models.FloatField(null=True)

    class Meta:
        db_table = 'feeder'
    def __str__(self):
        return f"Feeder {self.FeederID} - {self.FeederName}"
    def save_trained_model(self, model):
        # Serialize and save the trained model
        self.trained_model = pickle.dumps(model)
        self.save()


class WeatherStation(models.Model):
    id = models.IntegerField(primary_key=True)
    Name = models.CharField(max_length=30, null=True)
    Latitude = models.FloatField(null=True)
    Longitude = models.FloatField(null=True)
    X = models.FloatField(null=True)
    Y = models.FloatField(null=True)
    has_data = models.BooleanField(default=False)
    data_count = models.BigIntegerField(default=0)
    source = models.CharField(max_length=255, null=True)
    iid = models.IntegerField(null=True)
    valid = models.BooleanField(default=True)
    data_start = models.DateTimeField(null=True)
    data_end = models.DateTimeField(null=True)
    null_fields = models.CharField(max_length=255, null=True)
    Training_fields = models.CharField(max_length=255, null=True)
    exclude = models.BooleanField(default=False) # not used for AI training even if has data

    class Meta:
        db_table = 'weather_station'

    def __str__(self):
        return f"WeatherStation {self.Code} - {self.Name}"

class WeatherForecast(models.Model):
    weather_station_id = models.IntegerField()
    api_name = models.CharField(max_length=255)
    time = models.DateTimeField()
    created = models.DateTimeField(auto_now_add=True)
    updated = models.DateTimeField(auto_now=True)
    temperature = models.FloatField(null=True) #deg C
    humidity = models.FloatField(null=True) #%
    wind_speed = models.FloatField(null=True) #knots
    wind_direction = models.FloatField(null=True) #deg
    irradiance = models.FloatField(null=True) #W/m^2
    rainfall = models.FloatField(null=True) #mm
    riverlevel = models.FloatField(null=True) #m

    class Meta:
        db_table = 'weather_forecast'
        indexes = [
            models.Index(fields=['time']),
        ]

    def __str__(self):
        return f"WeatherForecast for {self.feeder_id} - {self.time}"

class Outage(models.Model):
    time_out = models.DateTimeField()
    time_in = models.DateTimeField()
    minutes = models.IntegerField()
    source = models.CharField(max_length=25)
    type = models.CharField(max_length=25)
    LC = models.CharField(max_length=4)
    feeder = models.CharField(max_length=4)
    zone = models.CharField(max_length=4)
    energy = models.FloatField() #kWh
    class Meta:
        db_table = 'outage'
        indexes = [
            models.Index(fields=['time_out']),
            models.Index(fields=['time_in']),
        ]