# Generated by Django 4.2.5 on 2023-09-14 22:49

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Feeder',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('OBJECTID', models.BigIntegerField(null=True)),
                ('load_identifier', models.CharField(max_length=10, null=True)),
                ('PrimaryBreaker', models.CharField(max_length=20, null=True)),
                ('FeederName', models.CharField(max_length=20, null=True)),
                ('SubstationID', models.SmallIntegerField(null=True)),
                ('bus_id', models.BigIntegerField(null=True)),
                ('etap_id', models.CharField(max_length=50, null=True)),
                ('etap_iid', models.BigIntegerField(null=True)),
                ('Shape', models.TextField(null=True)),
            ],
            options={
                'db_table': 'feeder',
            },
        ),
        migrations.CreateModel(
            name='FeederWeatherStation',
            fields=[
                ('feeder_id', models.IntegerField(primary_key=True, serialize=False)),
                ('weather_station_id', models.IntegerField()),
                ('distance', models.FloatField(null=True)),
            ],
            options={
                'db_table': 'feeder_weather_station',
            },
        ),
        migrations.CreateModel(
            name='Load',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField()),
                ('type', models.CharField(max_length=25, null=True)),
                ('feeder_id', models.IntegerField(null=True)),
                ('P', models.FloatField(null=True)),
                ('Q', models.FloatField(null=True)),
                ('P_forecast', models.FloatField(null=True)),
                ('Q_forecast', models.FloatField(null=True)),
                ('V_AB', models.FloatField(null=True)),
                ('V_BC', models.FloatField(null=True)),
                ('V_AC', models.FloatField(null=True)),
            ],
            options={
                'db_table': 'load',
            },
        ),
        migrations.CreateModel(
            name='WeatherStation',
            fields=[
                ('id', models.IntegerField(primary_key=True, serialize=False)),
                ('Name', models.CharField(max_length=30, null=True)),
                ('Latitude', models.FloatField(null=True)),
                ('Longitude', models.FloatField(null=True)),
                ('X', models.FloatField(null=True)),
                ('Y', models.FloatField(null=True)),
                ('has_data', models.BooleanField(default=False)),
                ('data_count', models.BigIntegerField(default=0)),
                ('source', models.CharField(max_length=255, null=True)),
                ('iid', models.IntegerField(null=True)),
                ('valid', models.BooleanField(default=True)),
            ],
            options={
                'db_table': 'weather_station',
            },
        ),
        migrations.CreateModel(
            name='WeatherTest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField(db_index=True)),
                ('weather_station_id', models.IntegerField()),
                ('temperature', models.FloatField(null=True)),
                ('humidity', models.FloatField(null=True)),
                ('irradiance', models.FloatField(null=True)),
                ('windspeed', models.FloatField(null=True)),
                ('winddirection', models.FloatField(null=True)),
                ('rainfall', models.FloatField(null=True)),
                ('riverlevel', models.FloatField(null=True)),
            ],
            options={
                'db_table': 'weather_test',
                'indexes': [models.Index(fields=['time'], name='weather_tes_time_5d2a6e_idx')],
            },
        ),
        migrations.CreateModel(
            name='WeatherStationForecast',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('weather_station_id', models.IntegerField()),
                ('api_name', models.CharField(max_length=255)),
                ('time', models.DateTimeField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('temperature', models.FloatField(null=True)),
                ('humidity', models.FloatField(null=True)),
                ('wind_speed', models.FloatField(null=True)),
                ('wind_direction', models.FloatField(null=True)),
                ('irradiance', models.FloatField(null=True)),
                ('rainfall', models.FloatField(null=True)),
            ],
            options={
                'db_table': 'weather_station_forecast',
                'indexes': [models.Index(fields=['time'], name='weather_sta_time_081344_idx')],
            },
        ),
        migrations.CreateModel(
            name='Weather',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField()),
                ('weather_station_id', models.IntegerField()),
                ('temperature', models.FloatField(null=True)),
                ('humidity', models.FloatField(null=True)),
                ('irradiance', models.FloatField(null=True)),
                ('windspeed', models.FloatField(null=True)),
                ('winddirection', models.FloatField(null=True)),
                ('rainfall', models.FloatField(null=True)),
                ('riverlevel', models.FloatField(null=True)),
            ],
            options={
                'db_table': 'weather',
                'indexes': [models.Index(fields=['time'], name='weather_time_8355b2_idx')],
            },
        ),
        migrations.CreateModel(
            name='WeatherForecast',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('api_name', models.CharField(max_length=255)),
                ('time', models.DateTimeField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('temperature', models.FloatField(null=True)),
                ('humidity', models.FloatField(null=True)),
                ('wind_speed', models.FloatField(null=True)),
                ('wind_direction', models.FloatField(null=True)),
                ('irradiance', models.FloatField(null=True)),
                ('rainfall', models.FloatField(null=True)),
                ('riverlevel', models.FloatField(null=True)),
                ('feeder', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='LF.feeder')),
            ],
            options={
                'db_table': 'weather_forecast',
                'indexes': [models.Index(fields=['time'], name='weather_for_time_11a224_idx')],
            },
        ),
    ]
