from django.db import models

# Create your models here.
class Fuel(models.Model):
    time = models.DateTimeField() #UTC
    Water_Inflow = models.FloatField(null=True)
    WTI_price = models.FloatField(null=True)

    class Meta:
        db_table = 'fuel'
        indexes = [
            models.Index(fields=['time']),
        ]

class ENSO(models.Model):
    time = models.DateTimeField() #UTC
    SST = models.FloatField(null=True)
    anomaly = models.FloatField(null=True)

    class Meta:
        db_table = 'ENSO'
        indexes = [
            models.Index(fields=['time']),
        ]

class ENSOForecast(models.Model):
    #https://www.cpc.ncep.noaa.gov/products/precip/CWlink/MJO/enso.shtml#forecast  --> Outlooks: Consolidated SST Outlook (NINO3.4)
    #https://www.cpc.ncep.noaa.gov/products/predictions/90day/tools/briefing/unger.pri.php
    time = models.DateTimeField() #UTC
    SST = models.FloatField(null=True)
    anomaly = models.FloatField(null=True)

    class Meta:
        db_table = 'ENSO_forecast'
        indexes = [
            models.Index(fields=['time']),
        ]

class HurricaneHistory(models.Model):
    time = models.DateTimeField() #UTC
    name = models.CharField(max_length=50, null=True)
    classification = models.CharField(max_length=5, null=True)
    latitude = models.FloatField(null=True)
    longitude = models.FloatField(null=True)
    wind = models.FloatField(null=True)
    pressure = models.FloatField(null=True)
    class Meta:
        db_table = 'hurricane_history'
        indexes = [
            models.Index(fields=['time']),
        ]

class WaterShed(models.Model):
    id = models.AutoField(primary_key=True)
    name = models.CharField(max_length=50, null=True)
    shape = models.TextField(null=True)
    class Meta:
        db_table = 'watershed'