class LocalRouter:
    def db_for_read(self, model, **hints):
        # Use the local_db for specific models or conditions
        if model._meta.app_label == 'LF' and model.__name__ in ['Test']:
            return 'local'
        return 'default'

    def db_for_write(self, model, **hints):
        if model._meta.app_label == 'LF' and model.__name__ in ['Test']:
            return 'local'
        return 'default'

    def allow_relation(self, obj1, obj2, **hints):
        return None

    def allow_migrate(self, db, app_label, model_name=None, **hints):
        if app_label == 'LF' and model_name in ['Test']:
            return db == 'local'
        return db == 'default'