# -*- coding: utf-8 -*-
__author__ = 'sandlbn and w3lly'

from django.views.generic import ListView, TemplateView
from django.http import HttpResponseRedirect
from .models import CalendarEvent
from .serializers import event_serializer
from .utils import timestamp_to_datetime
from .forms import EventForm
import datetime
import pytz


class CalendarJsonListView(ListView):

    template_name = 'django_bootstrap_calendar/calendar_events.html'

    def get_queryset(self):

        from_date = self.request.GET.get('from', False)
        to_date = self.request.GET.get('to', False)
        queryset = get_event_queryset(from_date, to_date)
        return event_serializer(queryset)

def Create_Event(request):
    # if this is a POST request we need to process the form data
    if request.method == "POST":
        # create a form instance and populate it with data from the request:
        form = EventForm(request.POST)
        # check whether it's valid:
        if form.is_valid():
            # process the data in form.cleaned_data as required
            event = form.save()
            # redirect to a new URL:
            return HttpResponseRedirect("/calendar/")

    # if a GET (or any other method) we'll create a blank form
    else:
        form = NameForm()
        context = {'form': form}
        return render(request, 'django_bootstrap_calendar/partial/calendar_create_event.html', context)
class CalendarView(TemplateView):

    template_name = 'django_bootstrap_calendar/calendar.html'


def get_event_queryset(from_date, to_date):
    queryset = CalendarEvent.objects.filter()
    modified_from_date = pytz.timezone('UTC').localize(timestamp_to_datetime(from_date) + datetime.timedelta(-30))
    from_date_localized = pytz.timezone('UTC').localize(timestamp_to_datetime(from_date))
    to_date_localized = pytz.timezone('UTC').localize(timestamp_to_datetime(to_date))
    if from_date and to_date:
        queryset = queryset.filter(
            start__range=(
                modified_from_date,
                to_date_localized
            )
        )
    elif from_date:
        queryset = queryset.filter(
            start__gte=from_date_localized
        )
    elif to_date:
        queryset = queryset.filter(
            end__lte=to_date_localized
        )
    return queryset