# -*- coding: utf-8 -*-
__author__ = 'sandlbn'

from django import template
from datetime import datetime
from time import mktime
from jsmin import jsmin
from django.conf import settings
import pytz

def timestamp_to_datetime(timestamp):
    """
    Converts string timestamp to datetime
    with json fix
    """
    if isinstance(timestamp, str):
        if len(timestamp) == 13:
            timestamp = int(timestamp) // 1000
        TZ = pytz.timezone(settings.TIME_ZONE)
        date = datetime.fromtimestamp(timestamp).replace(tzinfo=TZ).astimezone(pytz.utc).replace(tzinfo=None)
        return date
    else:
        return ""

def datetime_to_timestamp(date):
    """
    Converts datetime to timestamp
    with json fix
    """
    if isinstance(date, datetime):
        TZ = pytz.timezone(settings.TIME_ZONE)
        date = date.replace(tzinfo=pytz.utc).astimezone(TZ).replace(tzinfo=None)
        timestamp = mktime(date.timetuple())
        json_timestamp = int(timestamp) * 1000

        return '{0}'.format(json_timestamp)
    else:
        return ""


class MinifyJs(template.Node):

    def __init__(self, nodelist):
        self.nodelist = nodelist

    def render(self, context):
        return jsmin(self.nodelist.render(context))
