clear all
close all 
clc

%contatore
p=1;
q=1;

% Introduzione rete di distribuzione (IEEE 33-bus system)
% Valori base
Abase=1000; %kVA (valore modificato rispetto all'originale per renderlo
           % concorde all'articolo di Diaz2016
Vbase=12.66; %kV
Zbase=((Vbase*1000)^2)/(Abase*1000);
% Rami della rete
rete_completa=[0	 1;1	2;2	 3;3	4;4	 5;5	6;6	 7;7	8;8	 9;9	10;...
    10  11;11	12;12  13;13	14;14	15;15	16;16	17;1	18;...
    18	19;19	20;20	21;2	22;22	23;23	24;5	25;25	26;...
    26	27;27	28;28	29;29	30;30	31;31	32];
% Vettore delle impedenze dei rami (32 x 32)
Z_non_pu=[0.0922+1i*0.0470 0.493+0.2511i	0.366+0.1864i	0.3811+0.1941i	...
        0.819+0.707i 0.1872+0.6188i	0.7114+0.2351i	1.03+0.74i	...
        1.044+0.74i	 0.1966+0.065i	0.3744+0.1238i	1.468+1.155i ...
        0.5416+0.7129i 0.591+0.526i	0.7463+0.545i 1.289+1.721i	...
        0.732+0.574i 0.164+0.1565i	1.5042+1.3554i	0.4095+0.4784i	...
        0.7089+0.9373i	0.4512+0.3083i	0.898+0.7091i	0.896+0.7011i ...
        0.203+0.1034i	0.2842+0.1447i	1.059+0.9337i	0.8042+0.7006i	...
        0.5075+0.2585i	0.9744+0.963i	0.3105+0.3619i	0.341+0.5302i];
% Costruzione matrice delle incidenze (incluso lo slack, quindi 33x33)
incidenze_con_slack=zeros(max(max(rete_completa)),(max(max(rete_completa))));
for ii=1:(length(rete_completa)+1)
    incidenze_con_slack(ii, ii)=-1;
    if ii<(length(rete_completa)+1)
        incidenze_con_slack(rete_completa(ii,2)+1,rete_completa(ii,1)+1)=1;
    end
end
% Verifica radialità
verifica_radialita=det(incidenze_con_slack);
gamma_con_slack=inv(incidenze_con_slack);
NumNodi_conSlack=length(incidenze_con_slack);
NumNodi = NumNodi_conSlack-1;
% Matrice incidenze classica (slack escluso, 32 x 32)
incidenze=incidenze_con_slack(2:end, 2:end);
verifica_radialita=det(incidenze);
gamma=inv(incidenze);

% Calcolo le impedenze in pu  
Zpu=Z_non_pu/Zbase;
Zb_pu= diag(Zpu); % possibile perché i rami sono chiamati come i nodi finali
% Potenze attive in isola:
P_in_isola = [
         0.2  ;
         0.18 ;
         0.24 ;
         0.12 ;
        -0.001;%-0.861;
         0.4  ;
         0.4  ;
         0.12 ;
         0.12 ;
         0.09 ;
         0.12 ;
        -0.001;%-1.587;
         0.24 ;
         0.12 ;
         0.12 ;
         0.12 ;
         0.18 ;
         0.18 ;
         0.18 ;
         0.18 ;
         0.18 ;
         0.18 ;
         0.84 ;
         -0.001;%-0.141;
         0.12 ;
         0.12 ;
         0.12 ;
         0.24 ;
         0.4  ;
         0.3  ;
         0.42 ;
         -0.001;];%-1.184;];

%Potenze reattive in isola:
Q_in_isola = [
         0.12 ;
         0.08 ;
         0.16 ;
         0.06 ;
        -0.864;%-0.864;
         0.2  ;
         0.2  ;
         0.04 ;
         0.04 ;
         0.06 ;
         0.07 ;
        -0.861;%-0.861;
         0.16 ;
         0.02 ;
         0.04 ;
         0.04 ;
         0.08 ;
         0.08 ;
         0.08 ;
         0.08 ;
         0.08 ;
         0.1  ;
         0.4  ;
        -0.804;%-0.504;
         0.05 ;
         0.05 ;
         0.04 ;
         0.14 ;
         1.2  ;
         0.14 ;
         0.2  ;
        -0.836;];%-0.836];

% I valori del generatore di riferimento sono scritti a parte:
P_genrif_pu =0;%2.4;        % più i valori sono vicini alla potenza dei carichi: 1) più veloce è l'algoritmo 2)tensioni più basse
Q_genrif_pu =0;%0.5?  
nodo_riferimento = NumNodi_conSlack;
P_genrif_pu_iniziale = P_genrif_pu;
posizione_gen = find(P_in_isola<0);
nodi_generatori = [posizione_gen; nodo_riferimento];
generatori_limit = [nodi_generatori(1:end-1)];  %limito la potenza dei generatori



V_genrif = 1; % Non possiamo chiamarlo "Slack". Abbiamo solo un "generatore
                % di riferimento
V_genrif_vett=V_genrif .* ones(NumNodi,1);   %Inizializzo vettore tensioni
errore= 1;
errore2= 1;
niter = 0;
k_load=1;
k_pv=1;
k_hydro=1;
ore=1:1:24;%vettore da 1 a 24, con passo di 1
Nore=length(ore);


%Carico con multipli time step

% Profili di carico:rappresentano, in pu, l'andamento del carico
% giornaliero e della produzione. E' diviso in tipologie di utenze:
% 1)residenziale;
% 2)industriale;
% 3)terziario;
% 4)fotovoltaico;
% 5)acqua fluente.
 
% % residenziale
res=1e-1*[0.45,0.45,0.45,0.45,0.45,  0.5,  0.6,0.6,0.6,0.6,0.6,0.6,...
          0.6,0.6,0.6,0.6,  0.7, 0.8, 0.9, 1, 0.9, 0.8, 0.7, 0.6];

% % industriale
ind=[0.2,0.2,0.2,0.2,0.2, 0.4, 0.6, 0.9,0.9,0.9,0.9,0.9, 0.7, ...
     0.9,0.9,0.9,0.9, 0.6, 0.4, 0.2,0.2,0.2,0.2,0.2];

% % terziario
ter=[0.4,0.4,0.4,0.4,0.4, 0.5, 0.6, 0.7, 0.8, 0.78, 0.76, 0.74, 0.72, 0.7,... 
     0.68, 0.66, 0.64, 0.52, 0.4,0.4,0.4,0.4,0.4,0.4];

% % fotovoltaico
 pv=[0, 0, 0, 0, 0, 0, 0.1, 0.2, 0.3, 0.4, 0.7, 0.9, 0.9, 0.9, 0.8, 0.8,...
0.7, 0.6, 0.4, 0.3, 0.2, 0, 0, 0];

% % acqua fluente
 af=[1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];

%Valore potenza nominale
P_nom=k_load*[ %kW

 90     80   90    80    80    80      90   90   80   90      80    80      80    80     80   90    90    90   90      80    0    80    90     90    80     90   80    80    90    80     80     90;
 90     80   80    80     0    90      90   80   80   70      80    80      80    100   100   80     0    80   80      70   80    90    90     90    90     50    0    90    80    80     80      0;
 80     80   70    80    70    80      70   80   50   50       0     0      70     50    80    0    70    80    0       0    0    50    70     80     70    70    70   70    80     70    70     70;
  0      0   -50    0     0   -10     -80    0  -150   0    -100     0     -120   -90   -80    0   -90   -150   0       0  -150    0   -80      0   -120    -80  -60  -80   -80    -70   -70     0;
-100  -150  -90  -120     0   -150      0    0    0   -100     0     0        0     0     0  -120    0     0    0       0    0   -150    0      0      0      0    0    0     0      0     0     0;];

P_nom_pu=P_nom/Abase;


% % Valori del fattore di potenza
tg_phi=[
    0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,...
0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1;% residenziali 
    0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,...
0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5,0.5; % industriali
    0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,...
0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4,0.4; % terziario
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,...
0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0; % fotovoltaico
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,...
0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0;];%acqua fluente

Q_nom=P_nom.*tg_phi; % potenze reattive

profili=[k_load.*res;k_load.*ind;k_load.*ter;k_pv.*pv;k_hydro.*af];
Pcar=zeros(NumNodi,Nore);
Qcar=zeros(NumNodi,Nore);
% ciclo sui carichi:moltiplico le pot. nom. per i prof.di car
for k=1:(NumNodi)
   %creo Ptemp, che non è altro che la riga k-esima (ovvero riferita al...
   ...k-esimo nodo della rete in questione), replicata per le 24 ore
   ...(quindi Ptemp ha dimensioni 5*24.
   ...Ovviamente il tutto è moltiplicato, elemento per elemento,perprofili
   Ptemp=(repmat(P_nom(:,k),1,Nore)).*profili;
   
   %effettuo ora la somma lungo le colonnedi Ptemp ed ottengo 24 valori,
   %che rappresentano le 24 potenze giornaliere del nodo k-esimo
   Pcar(k,:)=sum(Ptemp,1);
   
   %Analogo discorso fatto in precedenza, ma per le potenze reattive
   Qtemp=(repmat(Q_nom(:,k),1,Nore)).*profili;
   Qcar(k,:)=sum(Qtemp,1);
end

% Carichi nodali a potenza assegnata
% potenze complesse dei nodi (righe) nelle varie ore (colonne)


% Si suddividono le potenze tra carichi e generatori:
P_car_pu = Pcar/Abase;
Q_car_pu = Qcar/Abase;

P_car_pu_iniziali = P_car_pu(:,1);
Q_car_pu_iniziali = Q_car_pu(:,1);

P_gen_pu = zeros(NumNodi,Nore);
P_gen_pu = -P_gen_pu/Abase; % Positivo generatori

Q_gen_pu = zeros(NumNodi,Nore);
Q_gen_pu = -Q_gen_pu/Abase; % Positivo generatori

P_gen_pu_iniziali = P_gen_pu(:,1);
Q_gen_pu_iniziali = Q_gen_pu(:,1);
Scar=(Pcar+1i*Qcar)/Abase;


%Impostazioni accumulo
accumulo_iniz=2.5; %accumulo a fine giornata partendo da accumulo nullo: 2.75368994816
pv_lim=0.4; %limite della potenza generata dal pv, al di sopra l'accumulo si carica, al di sotto l'accumulo si scarica
nodi_accumulo=[1 5 7 10 20 32];%nodi_generatori(1:end-1);
mp_acc_in=0.07.*ones(length(nodi_accumulo),1); %minimo 0.06
mp_acc_out=0.11.*ones(length(nodi_accumulo),1); %con i coefficienti regolo quanto velocemente l'energia viene assorbita e immessa
accumulo=accumulo_iniz/length(nodi_accumulo).*ones(length(nodi_accumulo),1); %suddivido la carica iniziale dell'accumulo in modo omogeneo
Gen_pv_pu=sum(P_nom(4,:)'.*pv)./Abase; %curva della generazione fotovoltaica, la confronto con pv_lim
acc_max=10; %valore massimo e minimo di accumulo
acc_min=0;

%Impostazione regolatore di tensione
deltaV_gen=10e-2;
V_gen_min = 1 - 0.5*deltaV_gen;
V_gen_max = 1 + 0.5*deltaV_gen;
Q_reg=0;
step_dQ=deltaV_gen/100;

%Impostazioni generatori
S_lim =[1.8; 1.8; 1.22; 1.5];
S_lim_rif =2.7842;

mp=[0.2; 0.2; 0.201; 0.2; 0.045];                                                                 
mq=mp;

% CASO 1: mp=[1; 0.1; 1; 0.2; 0.05];       S_lim=[1.33; 2.22; 0.88; 2.22]; S_lim_rif=3.4343;   
% CASO 2: mp=[0.16; 0.16; 1; 0.16; 0.05];  S_lim=[2.25; 1.75; 1.5; 1.75];  S_lim_rif=3.1842;
% CASO 3: mp=[0.2; 0.2; 0.201; 0.2; 0.05]; S_lim=[1.8; 1.8; 1.22; 1.5];    S_lim_rif=2.7842; 
% Valori calcolati con carico a singolo time-step (P_in_isola e
% Q_in_isola). Per il carico multi-step potrebbe essere necessario
% diminuire il valore del coefficiente di droop del nodo di riferimento (es. da 0.05 a 0.045)

Profili=profili;
P_carico=P_car_pu;
Q_carico=Q_car_pu;
PV_pu=Gen_pv_pu;
rng('default')

giorni=1; 

if giorni>1
for j=2:giorni    
r=randi([8 12]);    
P_carico=[P_carico (r/10).*P_car_pu];
Profili=[Profili (r/10).*profili];
r=randi([8 12]);
Q_carico=[Q_carico (r/10).*Q_car_pu];
PV_pu=[PV_pu Gen_pv_pu];
end
end

% Calcolo valore iniziale di deviazione di frequenza:
deltaf0 = 1/(sum((1./mp)))*(sum(P_gen_pu(:,1))+P_genrif_pu-sum(P_car_pu(:,1)));
deltaV0 = 0;%1/(sum((1./mq)))*(-sum(Q_car_pu)+sum(Q_gen_pu)+Q_genrif_pu);
deltaf=deltaf0;

tolleranza_f=10^-10;
tolleranza_V=10^-10;

format long
%%

% Ipotizzando che i generatori abbiano curva di capability di un convertitore statico (semicerchio)
% avente potenza apparente erogabile massima S_lim, calcolo all'inizio di
% ogni time step la potenza attiva massima che è possibile erogare tenendo
% conto della potenza reattiva richiesta dalla rete
for a=1:giorni*Nore

if a>1
Q_gen_pu(nodi_generatori(1:end-1),a)=Q_gen_pu(nodi_generatori(1:end-1),a-1); %le potenze generate iniziali di un'ora sono le le potenze generate nell'ora precedente
P_gen_pu(nodi_generatori(1:end-1),a) = P_gen_pu(nodi_generatori(1:end-1),a-1);
end

%accumulo
if k_pv~=0
if sum(accumulo)<acc_max %controllo che l'accumulo non sia carico al massimo
if abs(PV_pu(a))>pv_lim %confronto la potenza generata nell'ora a con la soglia imposta pv_lim
accumulo=accumulo + (abs(PV_pu(a))-pv_lim).*mp_acc_in; %l'energia va nell'accumulo
P_carico(nodi_accumulo,a)=P_carico(nodi_accumulo,a)+(abs(PV_pu(a))-pv_lim).*mp_acc_in; %aggiungo l'energia che è andata nell'accumulo al carico
end
end
if sum(accumulo)>acc_min %controllo che l'accumulo non sia scarico
if abs(PV_pu(a))<=pv_lim %confronto la potenza generata nell'ora a con la soglia imposta pv_lim
    if  (sum(mp_acc_out.*(pv_lim-abs(PV_pu(a))))>accumulo) %controllo se l'accumulo può immettere l'energia richiesta
         P_carico(nodi_accumulo,a)=P_carico(nodi_accumulo,a)-accumulo/length(nodi_accumulo); %se non può immette l'energia che può
         accumulo=0; %accumulo scarico
    else     
         accumulo=accumulo - mp_acc_out.*(pv_lim-abs(PV_pu(a))); %l'accumulo immette energia
         P_carico(nodi_accumulo,a)=P_carico(nodi_accumulo,a)-mp_acc_out.*(pv_lim-abs(PV_pu(a)));%sottraggo l'energia che è immessa dall'accumulo al carico
    end
end
end
end

acc(a)=sum(accumulo);

deltaf=deltaf0;
deltaf0 = 1/(sum((1./mp)))*(sum(P_gen_pu(:,a))+P_genrif_pu-sum(P_carico(:,a)));

while (errore2>tolleranza_V)
    v = V_genrif_vett;
    deltaQ_gen = -deltaV0./mq(1:end-1);
    Q_gen_pu(nodi_generatori(1:end-1),a) = Q_gen_pu(nodi_generatori(1:end-1),a) + deltaQ_gen;

while (errore>tolleranza_f)
    % Calcolo del valore di potenza dei generatori (tranne quello di 
    % riferimento sulla base del deltaf:
    deltaP_gen = -deltaf0./mp(1:end-1);    
    % E' aggiornato il valore delle potenze:
    P_gen_pu(nodi_generatori(1:end-1),a) = P_gen_pu(nodi_generatori(1:end-1),a) + deltaP_gen;    

    % Aggiorno potenza attiva limite dei generatori con vincoli
    % Ipotizzando che i generatori abbiano curva di capability di un convertitore statico (semicerchio)
    % avente potenza apparente erogabile massima S_lim, calcolo all'inizio di
    % ogni time step la potenza attiva massima ch è possibile erogare tenendo
    % conto della potenza reattiva richiesta dalla rete


    if ~isempty(S_lim)  
    for i=1:length(generatori_limit)
    %verifica potenza limite dei generatori
    if Q_gen_pu(generatori_limit(i),a)>=S_lim(i)
        P_gen_pu(generatori_limit(i),a)=0;
        Q_gen_pu(generatori_limit(i),a)=S_lim(i);
        P_lim(i)=0;
    else
    P_lim(i) = sqrt(S_lim(i)^2 -  Q_gen_pu(generatori_limit(i),a)^2);    
    if P_gen_pu(generatori_limit(i),a)>P_lim(i)
       P_gen_pu(generatori_limit(i),a)=P_lim(i);
    end
    if P_gen_pu(generatori_limit(i),a)<0
       P_gen_pu(generatori_limit(i),a)=0;
    end
    end
    end 
    end

    % Calcolo S_rete_pu:
    S_rete_pu = (P_carico(:,a)-P_gen_pu(:,a))+1i*(Q_carico(:,a)-Q_gen_pu(:,a));
    aa=sum(S_rete_pu);
    % Calcolo i_s e i_b (vettori delle correnti nodali e di ramo):
    i_s = conj(S_rete_pu)./conj(v); % Trascuro termini trasversali e carichi ad
                                    % ammettenza assegnata
    i_b = transpose(gamma)*i_s;
    % Calcolo i valori delle tensioni:
    v=V_genrif_vett-gamma*Zb_pu*i_b;

    % Calcolo il valore di potenza complessa che è fornita dal generatore di
    % riferimento:
    S_genrif_rete = V_genrif*conj(i_b(1)); % verso il nodo di riferimento
    % Ricalcolo il valore della frequenza:
    P_genrif_rete = real(S_genrif_rete);
    deltaf = mp(end)*(P_genrif_pu + P_genrif_rete);
    df(p)=deltaf; % andamento deltaf
    P_gen_temp(:,p) = [P_genrif_pu; P_gen_pu(nodi_generatori(1:end-1),a)]; % andamento Potenze attive
    Q_gen_temp(:,p) = [Q_genrif_pu; Q_gen_pu(nodi_generatori(1:end-1),a)]; % andamento Potenze reattive
    p=p+1;        

    P_genrif_pu=P_genrif_pu-deltaf/mp(end); %%%% MODIFICA AM 
    
    if abs(imag(S_genrif_rete))>=S_lim_rif
        P_genrif_pu=0;       
    else
    if abs(P_genrif_pu)>(sqrt(S_lim_rif^2 - (imag(-S_genrif_rete))^2))
        P_genrif_pu=(sqrt(S_lim_rif^2 - (imag(-S_genrif_rete))^2));
    end
    end
    if  P_genrif_pu<0
        P_genrif_pu=0;
    end     


    
% %     if P_genrif_rete>0 %Eccesso di generazione in rete
% %         if (P_genrif_rete-P_genrif_pu)<0
% %             % Nel caso di eccesso di generazione, il deltaP è calcolato come
% %             % quello che dovrebbe produrre il generatore di riferimento meno
% %             % ciò che il generatore sta producendo:
% %             deltaf = -mp(end)*(P_genrif_rete-P_genrif_pu);
% %         else
% %             deltaf = -mp(end)*(P_genrif_pu - P_genrif_rete);
% %         end
% % 
% %             % Aggiorno il generatore (è sensibile alla frequenza e modifica la
% %             % sua produzione in accodo con il suo droop):
% %             P_genrif_pu = P_genrif_pu-deltaf/mp(end);
% % 
% %     else
% %         % Nel caso di eccesso di carico in rete, il segno della potenza
% %         % verso rete cambia (diventa negativo).
% %         % Di conseguenza il deltaP di generazione 
% %         % generatore di riferimento è proprio quella cui si trova, partendo
% %         % dal valore che 
% %         deltaf= -mp(end)*(P_genrif_pu-abs(P_genrif_rete));
% % %         deltaf= -mp(end)*(abs(P_genrif_rete)-P_genrif_pu);
% %         P_genrif_pu = P_genrif_pu+deltaf/mp(end);
% %     end
    deltaf0=deltaf;
    errore = abs(deltaf);
    
%     P_genrif_pu = P_genrif_pu+real(S_genrif);




end
P_att(:,a)=P_gen_temp(:,p-1);
% Definiamo l'errore di tensione (che servirà nell'anello di controllo
% della tensione):
Q_genrif_rete = imag(S_genrif_rete);
deltaV = mq(end)*(Q_genrif_pu+Q_genrif_rete);
deltaV0=deltaV;
dV(q)=deltaV;    
V_genrif=V_genrif-deltaV;
V_rif(q)=V_genrif;
q=q+1;    
Q_genrif_pu=Q_genrif_pu-deltaV/mq(end); %%%% MODIFICA AM 

V_genrif_vett= V_genrif .* ones(NumNodi,1);
errore=1;
errore2= abs(deltaV);

% Regolazione tensione riferimento
if V_genrif>V_gen_max
    Q_reg=Q_reg+step_dQ;
else if V_genrif<V_gen_min    
         Q_reg=Q_reg-step_dQ;
else Q_reg=0;
end
end
Q_genrif_pu=Q_genrif_pu+Q_reg;
Regolazione_Q(q)=Q_reg;
end

perdite_att(a)= sum(real(Zb_pu)*abs(i_b).^2);
perdite_reatt(a)= sum(imag(Zb_pu)*abs(i_b).^2);
Q_att(:,a)=Q_gen_temp(:,p-1);
U_rif(a)=V_genrif;
freq(a)=deltaf;
errore2=1;
tensione_minima(a)=min(abs(v));
nodo_tensione_minima(a)=find(abs(v)==min(abs(v)));
tensione_massima(a)=max(abs(v));
nodo_tensione_massima(a)=find(abs(v)==max(abs(v)));

%Bilancio di potenze e perdite
bilancio_att(a)=abs(sum(P_att(:,a)))-abs(sum(P_carico(:,a)))-abs(perdite_att(a));
bilancio_reatt(a)=abs(sum(Q_att(:,a)))-abs(sum(Q_carico(:,a)))-abs(perdite_reatt(a));
fprintf('N time-step: %.2f\n', a)

end

%Plot della potenza reattiva della regolazione
% figure
% plot(Regolazione_Q(1:end-1),'-*')
% grid
% title('Potenza reattiva del regolatore di tensione')
% ylabel('Potenza reattiva in p.u.')
% xlabel('Numero di iterazioni del ciclo esterno')


%Plot delle tensioni ai nodi
% figure
% plot(1:(NumNodi),[abs(v)])
% grid
% title('Tensioni ai nodi')
% ylim([V_gen_min V_gen_max])

%Andamento della frequenza ad ogni loop interno
% figure
% plot(df)
% grid
% title('Variazione di frequenza istantanea')
% ylim([-0.1 0.1])

%Andamento della tensione di riferimento ad ogni loop esterno
% figure
% plot(dV)
% grid
% title('Variazione tensione di riferimento istantanea')
% ylim([-0.1 0.1])

%Andamento della frequenza a fine time-step
figure
plot(freq,'-*')
grid
title('Frequenza a fine ora')
ylim([-0.1 0.1])
xlim([1 Nore*giorni])

%Plot della tensione di riferimento alla fine di ogni time-step
figure
plot(U_rif,'-*')
grid
title('Tensione di riferimento a fine ora')
ylim([V_gen_min V_gen_max])
ylabel('Valore tensione in pu')
xlabel('Time step')
ylim([V_gen_min-(1-V_gen_min) V_gen_max+(1-V_gen_min)])
xlim([1 Nore*giorni])

%Plot delle potenze attive alla fine di ogni time-step
figure
for i=1:length(nodi_generatori)
plot(P_att(i,:))
hold on
end
grid
legend('Nodo riferimento', 'Nodo 5', 'Nodo 12', 'Nodo 24', 'Nodo 32')
title('Andamento potenze attive a fine ora')

%Plot delle potenze reattive alla fine di ogni time-step
figure
for i=1:length(nodi_generatori)
plot(Q_att(i,:))
hold on
end 
grid
legend('Nodo riferimento', 'Nodo 5', 'Nodo 12', 'Nodo 24', 'Nodo 32')
title('Andamento potenze reattive a fine ora')

%Plot dell'andameno della potenza attiva per ogni iterazione del loop interno
% figure
% for i=1:length(nodi_generatori)
% plot(P_gen_temp(i,:))
% hold on
% end 
% grid
% legend('Nodo riferimento', 'Nodo 5', 'Nodo 12', 'Nodo 24', 'Nodo 32')
% title('Potenze attive istantanee')

%Plot dell'andameno della potenza reattiva per ogni iterazione del loop esterno
% figure
% for i=1:length(nodi_generatori)
% plot(Q_gen_temp(i,:))
% hold on
% end 
% grid
% legend('Nodo riferimento', 'Nodo 5', 'Nodo 12', 'Nodo 24', 'Nodo 32')
% title('Potenze reattive istantanee')

%Plot del regolatore di tensione
% V_gen_rif=0:0.005:1.5;
% figure
% for i=1:length(V_gen_rif)
%    if V_gen_rif(i)>V_gen_max
%     Q_genrif_pu=Q_rif_min;
% end    
% if V_gen_rif(i)<V_gen_min
%     Q_genrif_pu=Q_rif_max;
% end    
% if (V_gen_rif(i)<=V_gen_max && V_gen_rif(i)>=V_gen_min) 
%     Q_genrif_pu=QV*(V_gen_rif(i)-V_gen_min)+Q_rif_max;
% end  
% Q(i)=Q_genrif_pu;
% end
% plot(V_gen_rif(1:i), Q(:))
% grid
% title('Regolatore di tensione')

%Plot dell'andamento del carico attivo e della potenza attiva generata dai generatori
figure
plot(sum(P_carico),'-*')
grid
hold on
plot(sum(P_att),'-*')
legend('Carico', 'Generazione')
title('Profili carico attivo e generazione attiva')
xlabel('Time step')
xlim([1 Nore*giorni])

%Plot dell'andamento del carico reattivo e della potenza reattiva generata dai generatori
figure
plot(sum(Q_carico),'-*')
grid
hold on
plot(sum(Q_att),'-*')
legend('Carico', 'Generazione')
title('Profili carico reattivo e generazione reattiva')
xlabel('Time step')
xlim([1 Nore*giorni])

%Plot andamento carica dell'accumulo
figure
plot(acc,'-*')
grid
title('Andamento accumulo')
xlabel('Time step')
ylabel('Energia accumulata in pu')
xlim([1 Nore*giorni])

%Plot del bilancio di potenze arrive e reattive
figure
plot(bilancio_att,'-*')
hold on
plot(bilancio_reatt,'-*')
grid
legend('Bilancio Pot. Attive', 'Bilancio Pot. Reattive')
title('Bilancio di potenze attive e reattive')
ylim(1e-5.*[-1 1])
xlabel('Time step')
ylabel('Valori in p.u.')
xlim([1 Nore*giorni])

%Nodo con tenione minima
figure
subplot(2,1,1)
plot(nodo_tensione_minima,'-*')
grid
title('posizione del nodo con tensione più bassa')
ylabel('Posizione nodo')
xlabel('Time step')
ylim([1 32])
xlim([1 Nore*giorni])
subplot(2,1,2)
plot(tensione_minima,'-*')
grid
title('Tensione del nodo con tensione più bassa')
ylabel('Tensione in pu')
xlabel('Time step')

%Nodo con tenione massima
figure
subplot(2,1,1)
plot(nodo_tensione_massima,'-*')
grid
title('posizione del nodo con tensione più alta')
ylabel('Posizione nodo')
xlabel('Time step')
ylim([1 32])
xlim([1 Nore*giorni])
subplot(2,1,2)
plot(tensione_massima,'-*')
grid
title('Tensione del nodo con tensione più alta')
ylabel('Tensione in pu')
xlabel('Time step')

%plot del carico elettrico
figure
for i=1:5
    plot(Profili(i,:), '-*')
    hold on
end    
title('Profili di carico giornaliero')
legend('residenziale', 'industriale', 'terziario', 'fotovoltaico', 'acqua fluente')
xlabel('Time step')
ylabel('Potenza in p.u.')
grid
ylim([-0.1 2])
xlim([1 Nore*giorni])
% 1)residenziale;
% 2)industriale;
% 3)terziario;
% 4)fotovoltaico;
% 5)acqua fluente.