
clear all
close all 
clc


% Struttura rete
load('ReteRurale_profili.mat'); % Il grafico della rete ha i nodi che iniziano da 1 (slack)
incidenze=L;
radial_check=det(incidenze); % controllo di radialit (rete radiale se il determinante  1 o -1)

gamma=inv(incidenze);

%Dati rami
Zb=Zb_pu;
% Ammettenza trasversale totale linee
Ysh=Ysh_pu;

% Aggregazione per nodi dei parametri trasversali delle linee
Ytotnodi=abs(transpose(incidenze))*Ysh/2;

% Carichi ad ammettenza assegnata
Ycar=Ycar_pu;

% Grandezze base
Vbase=Vbase_kV;% kV
Sbase=Sbase_kVA; % kVA
Ibase=Sbase/(sqrt(3)*Vbase); % A

% Limiti termici linee
Imax=Ilim_Ampere/Ibase;    % valore in per unita'

% Dati profili di carico e generazione (dal file di input)
profili=[res';ind';agr';PV'];

% Vettore tempi
N_ore = 24;
Ntime_steps=length(res);
time_step=1:1:Ntime_steps;

% figure
% % residenziale
% plot (time_step,res','-*')
% axis([0,Ntime_steps,0,1])
% % industriale
% hold on
% plot (time_step,ind','r-*')
% % terziario
% hold on
% plot (time_step,agr','g-*')
% % fotovoltaico
% hold on
% plot (time_step,PV','b-*')
% title('Andamento Carichi')
% xlabel('Time step')
% ylabel('Potenza in pu')
% grid
% xlim([1 Ntime_steps])
% ylim([-0.1 1.1])
% legend('residenziale', 'industriale', 'terziario', 'fotovoltaico')

% Potenza attiva e reattiva nominale dei carichi ai nodi
% ogni riga rappresenta una tipologia di carico o generazione per i nodi della rete
P_nom=[P_res';P_ind';P_agr';P_PV'];
Q_nom=[Q_res';Q_ind';Q_agr';Q_PV'];

% Carichi nodali a potenza assegnata
% potenze complesse dei nodi (righe) nelle varie ore (colonne)
Pcar=zeros(NumNodi,Ntime_steps);%% 
Qcar=zeros(NumNodi,Ntime_steps);
for k=1:NumNodi   % ciclo sui carichi
   Ptemp=repmat(P_nom(:,k),1,Ntime_steps).*profili;  %%repmat crea i profili di potenza totale della rete nel tempo
   Pcar(k,:)=sum(Ptemp,1); 
   Qtemp=repmat(Q_nom(:,k),1,Ntime_steps).*profili;
   Qcar(k,:)=sum(Qtemp,1);
end

Pcar_pu=Pcar/Sbase;
Qcar_pu=Qcar/Sbase;
errore_f=1;
errore_V=1;
nodo_slack=NumNodi+1;
nodi_gen=[find(Pcar(:,1)==0); nodo_slack];
% nodi_gen=nodi_gen(2:end); %escludo nodo 1
Pgen_pu=zeros(NumNodi, Ntime_steps);
Qgen_pu=Pgen_pu;


% IMPOSTAZIONI GENERATORI
generatori_limit = nodi_gen(1:end-1);  
S_lim =100.*ones(length(nodi_gen(1:end-1,1)),1); 
S_lim_rif =100;

Pgenrif_pu=0;
Qgenrif_pu=0;

mp_rif=0.05;
mp=[0.25; 0.50; 0.40; 1.00; 0.60; 0.65; mp_rif];  %[0.25; 0.50; 0.40; 1.00; 0.60; 0.65; mp_rif]; 
mq=mp;

% IMPOSTAZIONI REGOLATORE DI TENSIONE 
deltaV_gen=10e-2;
V_gen_min = 1 - 0.5*deltaV_gen;
V_gen_max = 1 + 0.5*deltaV_gen;
Q_reg=0;
step_dQ=deltaV_gen/100;
V_genrif=1;
V_genrif_vett= V_genrif .* ones(NumNodi,1);

q=1;
p=1;
tolleranza_f=10^-10;
tolleranza_V=10^-10;

% Calcolo valore iniziale di deviazione di frequenza:
deltaf0 = 1/(sum((1./mp)))*(sum(Pgen_pu(:,1))+Pgenrif_pu-sum(Pcar_pu(:,1)));
deltaV0 = 0;%1/(sum((1./mq)))*(-sum(Q_car_pu)+sum(Q_gen_pu)+Q_genrif_pu);
deltaf=deltaf0;

rng('default')
y=1;
giorni=1;

Profili=profili;
PROFILI=Profili;
P_carico=Pcar_pu;
Q_carico=Qcar_pu;
format long

%%
for x=1:giorni
    r=randi([8 12]);
    Pcar_pu=(r/10).*Pcar_pu;
    Profili=(r/10).*profili;
    r=randi([8 12]);
    Qcar_pu=(r/10).*Qcar_pu;    
    
    if x>1
    P_carico=[P_carico Pcar_pu];
    Q_carico=[Q_carico Qcar_pu];
    PROFILI=[PROFILI Profili];
    end

for h=1:Ntime_steps

    if h>1
    Pgen_pu(nodi_gen(1:end-1),h) = Pgen_pu(nodi_gen(1:end-1),h-1);
    Qgen_pu(nodi_gen(1:end-1),h) = Qgen_pu(nodi_gen(1:end-1),h-1);
    end

while (errore_V>tolleranza_V)
 
    v = V_genrif_vett;   %nuovo vettore delle tensioni con tensione di riferimento aggiornata
    deltaQ_gen = -deltaV0./mq(1:end-1); %variazione delle potenza reattive dei generatori in base ai coefficienti di droop e variazione tensione di riferimento
    Qgen_pu(nodi_gen(1:end-1),h) = Qgen_pu(nodi_gen(1:end-1),h) + deltaQ_gen; %aggiorno le potenze reattive dei generatori
    

while (errore_f>tolleranza_f)

    % Calcolo del valore di potenza dei generatori (tranne quello di 
    % riferimento sulla base del deltaf:
    deltaP_gen = -deltaf0./mp(1:end-1);
    % E' aggiornato il valore delle potenze:
    Pgen_pu(nodi_gen(1:end-1),h) = Pgen_pu(nodi_gen(1:end-1),h) + deltaP_gen;    

    % Aggiorno potenza attiva limite dei generatori con vincoli
    % Ipotizzando che i generatori abbiano curva di capability di un 
    % convertitore statico (semicerchio) avente potenza apparente erogabile
    % massima S_lim, calcolo all'inizio di ogni time step la potenza attiva 
    % massima che  possibile erogare tenendo conto della potenza reattiva
    % richiesta dalla rete

    if ~isempty(S_lim)
        for i=1:length(generatori_limit)
            %verifica potenza limite dei generatori
            if Qgen_pu(generatori_limit(i),h)>=S_lim(i)
                Pgen_pu(generatori_limit(i),h)=0;
                Qgen_pu(generatori_limit(i),h)=S_lim(i);
                P_lim(i)=0;
            else
                P_lim(i) = sqrt(S_lim(i)^2 -  Qgen_pu(generatori_limit(i),h)^2);
                if Pgen_pu(generatori_limit(i),h)>P_lim(i)
                    Pgen_pu(generatori_limit(i),h)=P_lim(i);
                end
                if Pgen_pu(generatori_limit(i),h)<0
                    Pgen_pu(generatori_limit(i),h)=0;
                end
            end
            end
    end
 
   % Calcolo S_rete_pu:
    S_rete_pu(:,h) = (P_carico(:,y)-Pgen_pu(:,h))+1i.*(Q_carico(:,y)-Qgen_pu(:,h));
    aa=sum(S_rete_pu);

   % Ciclo di calcolo load-flow backward/forward sweep
   I_Scar = conj(S_rete_pu(:,h)) ./ conj(v);
   I_Ycar = Ycar_pu .* v;
   I_Ytotnodi = Ytotnodi .* v;
   I_s = I_Scar + I_Ycar + I_Ytotnodi;
   I_b = transpose(gamma) * I_s;
   v = V_genrif_vett -gamma*Zb_pu*I_b;

    % Calcolo il valore di potenza complessa che  fornita dal generatore di
    % riferimento:
    S_genrif_rete = V_genrif*conj(I_b(1)); % verso il nodo di riferimento
    % Ricalcolo il valore della frequenza:
    P_genrif_rete = real(S_genrif_rete);
    deltaf = mp(end)*(Pgenrif_pu + P_genrif_rete);
    Pgenrif_pu=Pgenrif_pu-deltaf/mp(end); %%%% MODIFICA AM 
    deltaf0=deltaf;
    errore_f = abs(deltaf);
    P_gen_temp(:,p) = [Pgenrif_pu; Pgen_pu(nodi_gen(1:end-1),h)]; % andamento Potenze attive
    p=p+1;
    
    if abs(imag(S_genrif_rete))>=S_lim_rif
        Pgenrif_pu=0;       
    else
    if abs(Pgenrif_pu)>(sqrt(S_lim_rif^2 - (imag(-S_genrif_rete))^2))
        Pgenrif_pu=(sqrt(S_lim_rif^2 - (imag(-S_genrif_rete))^2));
    end
    end
    if  Pgenrif_pu<0
         Pgenrif_pu=0;
    end     
end
P_att(:,y)=P_gen_temp(:,p-1);


% Definiamo l'errore di tensione (che servir nell'anello di controllo
% della tensione):
Q_genrif_rete = imag(S_genrif_rete);
deltaV = mq(end)*(Qgenrif_pu+Q_genrif_rete);
deltaV0=deltaV;    
V_genrif=V_genrif-deltaV;      
Qgenrif_pu = Qgenrif_pu - deltaV/mq(end); %%%% MODIFICA AM 
dV(q)=V_genrif;
V_genrif_vett= V_genrif .* ones(NumNodi,1);

errore_f=1;
errore_V= abs(deltaV);
Q_gen_temp(:,q) = [Qgenrif_pu; Qgen_pu(nodi_gen(1:end-1),h)]; % andamento Potenze reattive
q=q+1;

%Regolatore di tensione

if V_genrif>V_gen_max
    Q_reg=Q_reg+step_dQ;
else if V_genrif<V_gen_min    
         Q_reg=Q_reg-step_dQ;
else Q_reg=0;
end
end
Qgenrif_pu=Qgenrif_pu+Q_reg;
Regolazione(p)=Q_reg;


end

errore_V=1;
df(y)=deltaf;
perdite_att(y)=sum((real(Zb_pu)*abs(I_b).^2));
perdite_reatt(y)=sum((imag(Zb_pu)*abs(I_b).^2)) - sum((imag(Ytotnodi).*abs(v).^2));
perdite_reatt_i(y)=sum((imag(Zb_pu)*abs(I_b).^2));
perdite_reatt_v(y)=- sum((imag(Ytotnodi).*abs(v).^2));
Q_att(:,y)=Q_gen_temp(:,q-1);
U_rif(y)=V_genrif;
tensione_minima(y)=min(abs(v));
nodo_tensione_minima(y)=find(abs(v)==min(abs(v)));
fprintf('Giorno: %2d      Ora: %.2f\n', x, h/Ntime_steps*24)
%Bilancio di potenze e perdite
bilancio_att(y)=sum(P_att(:,y))-(sum(P_carico(:,y)))-sum(perdite_att(y));
bilancio_reatt(y)=sum(Q_att(:,y))-(sum(Q_carico(:,y)))-perdite_reatt(y);
y=y+1;
end

end



%Plot delle tensioni ai nodi della rete
% figure
% plot(1:(NumNodi),[abs(v)])
% grid
% title('Tensioni ai nodi')
% xlim([1 102])
% ylim([V_gen_min V_gen_max])

%Plot dell'andameno della variazione di frequenza per ogni iterazione del loop interno
figure
plot(df,'-*')
grid
title('Variazione di frequenza ad ogni time-step')
ylim([-1e-5 1e-5])


%Plot dell'andameno della variazione di tensione di riferimento per ogni iterazione del loop esterno
% figure
% plot(dV)
% grid
% title('Tensione di riferimento istantanea')
% xlabel('Numero cicli esterni')
% ylabel('Valore di tensione (pu)')
% xlim([1 q-1])

%Plot dell'andameno della potenza attiva per ogni iterazione del loop interno
% figure
% for i=1:length(nodi_gen)
% plot(P_gen_temp(i,:))
% hold on
% end 
% grid
% legend('Nodo riferimento', 'Nodo 1', 'Nodo 6', 'Nodo 28', 'Nodo 38', 'Nodo 52', 'Nodo 81')
% title('Potenze attive istantanee')

%Plot dell'andameno della potenza reattiva per ogni iterazione del loop esterno
% figure
% for i=1:length(nodi_gen)
% plot(Q_gen_temp(i,:))
% hold on
% end 
% grid
% legend('Nodo riferimento', 'Nodo 1', 'Nodo 6', 'Nodo 28', 'Nodo 38', 'Nodo 52', 'Nodo 81')
% title('Potenze reattive istantanee')

%Plot dell'andamento del carico attivo e della potenza attiva generata dai generatori
figure
plot(sum(P_carico),'-*')
grid
hold on
plot(sum(P_att),'-*')
legend('Carico', 'Generazione')
title('Profili carico e generazione potenza attiva')

%Plot dell'andamento del carico reattiva e della potenza reattiva generata dai generatori
figure
plot(sum(Q_carico),'-*')
grid
hold on
plot(sum(Q_att)-perdite_reatt_v,'-*')
legend('Carico', 'Generazione')
title('Profili carico e generazione potenza reattiva')

%Plot della tensione di riferimento alla fine di ogni time-step
figure
plot(U_rif,'-*')
grid
title('Tensione di riferimento ad ogni time-step')

%Plot delle potenze attive alla fine di ogni time-step
figure
for i=1:length(nodi_gen)
plot(P_att(i,:),'-*')
hold on
end
grid
legend('Nodo riferimento', 'Nodo 2', 'Nodo 7', 'Nodo 29', 'Nodo 39', 'Nodo 53', 'Nodo 82')
title('Andamento potenze attive ad ogni time-step')

%Plot delle potenze reattive alla fine di ogni time-step
figure
for i=1:length(nodi_gen)
plot(Q_att(i,:),'-*')
hold on
end 
grid
legend('Nodo riferimento', 'Nodo 2', 'Nodo 7', 'Nodo 29', 'Nodo 39', 'Nodo 53', 'Nodo 82')
title('Andamento potenze reattive ad ogni time-step')


%Plot del bilancio di potenze arrive e reattive
figure
plot(bilancio_att,'-*')
hold on
plot(bilancio_reatt,'-*')
grid
legend('Bilancio Pot. Attive', 'Bilancio Pot. Reattive')
title('Bilancio di potenze arrive e reattive')

%Nodo con tensione minima
figure
subplot(2,1,1)
plot(nodo_tensione_minima,'-*')
grid
title('posizione del nodo con tensione pi bassa')
ylabel('Posizione nodo')
ylim([0 NumNodi])
xlabel('Time step')
xlim([1 Ntime_steps*giorni])
subplot(2,1,2)
plot(tensione_minima,'-*')
grid
title('Valore della tensione pi bassa')
ylabel('Valore tensione pu')
xlabel('Time step')
xlim([1 Ntime_steps*giorni])

%Plot profili
figure
plot(PROFILI(1,:),'-*')
hold on
plot(PROFILI(2,:),'r-*')
hold on
plot(PROFILI(3,:),'g-*')
hold on
plot(PROFILI(4,:),'b-*')
title('Andamento Carichi')
xlabel('Time step')
ylabel('Potenza in pu')
grid
xlim([1 Ntime_steps*giorni])
ylim([-0.1 1.3])
legend('residenziale', 'industriale', 'terziario', 'fotovoltaico')

%plot potenze reattive ad ongi iterazione del loop esterno
% figure
% for i=1:length(nodi_gen)
% plot(Q_gen_temp(i,:))
% hold on
% end
% grid
% title('Potenze reattive ad ogni ciclo esterno')
% xlabel('Numero cicli esterni totali')
% ylabel('Potenza reattiva (pu)')
% legend('Nodo riferimento', 'Nodo 2', 'Nodo 7', 'Nodo 29', 'Nodo 39', 'Nodo 53', 'Nodo 82')
% xlim([1 q-1])
ylim([-0.1 1.3])