%% tabella
S0 = [90, 100, 110];
NRepl = 10000;
K = 100;
r = 0.05;
sigma = 0.2;
T = 1;
eps = 0.7;

deltaPath= zeros(1,3);
deltaLRAV= zeros(1,3);
deltaLR = zeros(1,3);
deltaFDCN = zeros(1,3);
varLR = zeros(1,3);
varPath = zeros(1,3);
varFDCN = zeros(1,3); 
varLRAV = zeros(1,3);

for i = 1:3
    [deltaFDCN(i), varFDCN(i)] = AsianDeltaLRAV(S0(i),K,r,T,sigma,NSteps,NRepl);
    [deltaPath(i), varPath(i)] = AsianVegaLR(S0(i),K,r,T,sigma,NSteps,NRepl);
    [deltaLR(i), varLR(i)] = AsianRhoLRAV(S0(i),K,r,T,sigma,NSteps,NRepl);
    [deltaLRAV(i), varLRAV(i)] = AsianGammaLRAV(S0(i),K,r,T,sigma,NSteps,NRepl);
end

errLR = varLR/sqrt(NRepl);
errFDCN = varFDCN/sqrt(NRepl);
errLRAV = varLRAV/sqrt(NRepl);
errPath = varPath/sqrt(NRepl);

% Calcola l'unione alternata di a e b
lr = reshape([deltaLR; errLR], 1, []);
lrav = reshape([deltaLRAV; errLRAV], 1, []);
fd = reshape([deltaFDCN; errFDCN], 1, []);
path = reshape([deltaPath; errPath], 1, []);

% Visualizza il vettore risultante
fprintf('& %.4f ', fd);
fprintf('\n');
fprintf('& %.4f ', lr);
fprintf('\n');
fprintf('& %.4f ', lrav);
fprintf('\n');
fprintf('& %.4f ', path);
fprintf('\n');
%% Finite diff
S0 = 100;
NSteps = 12;
NRepl = 10000;
K = 100;
r = 0.05;
sigma = 0.2;
T = 1;
eps = [0.5, 0.2, 0.1, 0.01, 0.001];
eps2 = sqrt([0.1, 0.5, 0.01, 0.001, 0.0001]);

deltaPath= zeros(1,5);
deltaLR = zeros(1,5);
deltaFDCN = zeros(1,5);
deltaEaxct = zeros(1,5);
var1FDCN = zeros(1,5);
var2FDCN = zeros(1,5); 
var3FDCN = zeros(1,5);
var4FDCN = zeros(1,5);

for i = 1:5
    [deltaFDCN(i), var1FDCN(i)] = AsianDeltaFDCN(S0,K,r,T,sigma,NSteps,NRepl,eps(i));
    [deltaFDCN(i), var2FDCN(i)] = AsianGammaFDCN(S0,K,r,T,sigma,NSteps,NRepl,eps2(i));
    [deltaFDCN(i), var3FDCN(i)] = AsianVegaFDCN(S0,K,r,T,sigma,NSteps,NRepl,eps(i));
    [deltaFDCN(i), var4FDCN(i)] = AsianRhoFDCN(S0,K,r,T,sigma,NSteps,NRepl,eps(i));

end

err1FDCN = var1FDCN/sqrt(NRepl);
err2FDCN = var2FDCN/sqrt(NRepl);
err3FDCN = var3FDCN/sqrt(NRepl);
err4FDCN = var4FDCN/sqrt(NRepl);

% Plot con punti e barre di errore
figure;
plot(eps, err4FDCN, 'o-', 'LineWidth', 1.5, 'MarkerSize', 8);
xlabel('h');
ylabel('Sd Err');
title('Standard error al variare di h');
grid on;
legend('Sd Err');


%% LR volatility 
deltaLR = zeros(1,15);
deltaLRAV = zeros(1,15);
varLR = zeros(1,15);
varLRAV = zeros(1,15);
NSteps = 12;
Sb = 120;
 
sigmaLR = linspace(0.003,0.15,15);
TLR = linspace(0.1,1,15);

for i = 1:15
    [deltaLR(i), varLR(i)] = AsianDeltaLR(S0,K,r,T,sigmaLR(i),NSteps,NRepl);
    [deltaLRAV(i), varLRAV(i)] = AsianDeltaLRAV(S0,K,r,T,sigmaLR(i),NSteps,NRepl);
end

figure;
plot(sigmaLR, varLR, 'o-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'var LR');
hold on;
plot(sigmaLR, varLRAV, 's-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'var LRAV');
hold off;

xlabel('\sigma');
ylabel('var');
title('Varianza del delta LR in funzione di \sigma');
grid on;

% Inverti l'asse x
set(gca, 'XDir', 'reverse');
legend('Location', 'northwest')



%%  Asian m varying
S0 = 100;
NSteps = [4, 8, 32, 64, 96, 128, 160, 192, 224, 256];
eps = 0.05;

deltaPath= zeros(1,10);
deltaLRAV= zeros(1,10);
deltaLR = zeros(1,10);
deltaFDCN = zeros(1,10);
varLR = zeros(1,10);
varPath = zeros(1,10);
varFDCN = zeros(1,10); 
varLRAV = zeros(1,10);

for i = 1:10
    [deltaFDCN(i), varFDCN(i)] = AsianGammaFDCN(S0,K,r,T,sigma,NSteps(i),NRepl,eps);
    %[deltaPath(i), varPath(i)] = AsianRhoPath(S0,K,r,T,sigma,NSteps(i),NRepl);
    [deltaLR(i), varLR(i)] = AsianGammaLR(S0,K,r,T,sigma,NSteps(i),NRepl);
    [deltaLRAV(i), varLRAV(i)] = AsianGammaLRAV(S0,K,r,T,sigma,NSteps(i),NRepl);
end

errLR = varLR/sqrt(NRepl);
errFDCN = varFDCN/sqrt(NRepl);
errLRAV = varLRAV/sqrt(NRepl);
errPath = varPath/sqrt(NRepl);

figure;
plot(NSteps, errLR, 'o-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'LR');
hold on;
plot(NSteps, errFDCN, 's-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'FDCN');
plot(NSteps, errLRAV, '^-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'LRAV');
%plot(NSteps, errPath, 'd-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'Path');

xlabel('m');
ylabel('Sd Err');
title('Standard error di gamma al variare di m');
grid on;
legend('Location','northwest');

%%
S0 = 100;
Sb = [102, 105, 107, 110, 115, 117, 120, 130, 140, 150];
eps = 0.0001;
NSteps = 12;

deltaPath= zeros(1,10);
deltaLRAV= zeros(1,10);
deltaLR = zeros(1,10);
deltaFDCN = zeros(1,10);
varLR = zeros(1,10);
varPath = zeros(1,10);
varFDCN = zeros(1,10); 
varLRAV = zeros(1,10);

for i = 1:10
    [deltaFDCN(i), varFDCN(i)] = UOCallDeltaFDCN(S0,K,r,T,sigma,Sb(i),NSteps,NRepl,eps);
    %[deltaPath(i), varPath(i)] = AsianDeltaPath(S0,K,r,T,sigma,NSteps(i),NRepl);
    [deltaLR(i), varLR(i)] = UOCallDeltaLR(S0,K,r,T,sigma,Sb(i),NSteps,NRepl);
    [deltaLRAV(i), varLRAV(i)] = UOCallDeltaLRAV(S0,K,r,T,sigma,Sb(i),NSteps,NRepl);
end

errLR = varLR/sqrt(NRepl);
errFDCN = varFDCN/sqrt(NRepl);
errLRAV = varLRAV/sqrt(NRepl);
errPath = varPath/sqrt(NRepl);

figure;
plot(Sb, errLR, 'o-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'LR');
hold on;
plot(Sb, errFDCN, 's-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'FDCN');
plot(Sb, errLRAV, '^-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'LRAV');
%plot(NSteps, errPath, 'd-', 'LineWidth', 1.5, 'MarkerSize', 8, 'DisplayName', 'Path');

xlabel('m');
ylabel('Sd Err');
title('Standard error al variare di m');
grid on;
legend('Location', 'northeast')