function [vega, var, CI] = UOCallVegaLRAV(S0,K,r,T,sigma,Sb,NSteps,NRepl)

%Asset path generation 
Path1 = zeros(1, 1+NSteps);
Path1(1) = S0;

Path2 = zeros(1, 1+NSteps);
Path2(1) = S0;

dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
LR = zeros(1,NRepl);
ncross = 0;

for i=1:NRepl
   score1 = 0;
   score2 = 0;
   for j=1:NSteps
      Z1 = randn;
      Z2 = -Z1;
      Path1(j+1)=Path1(j)*exp(nudt+sidt*Z1);
      Path2(j+1)=Path2(j)*exp(nudt+sidt*Z2);
      score1 = score1+(Z1^2-1)/sigma-Z1*sqrt(dt);
      score2 = score2+(Z2^2-1)/sigma-Z2*sqrt(dt);
   end
      crossed1 = any(Path1 >= Sb);
   if crossed1 == 0
       payoff1 = exp(-r*T)*max(0, Path1(NSteps+1)-K);
   else
       payoff1 = 0;
       ncross = ncross+1;
   end
   crossed2 = any(Path2 >= Sb);
   if crossed2 == 0
       payoff2 = exp(-r*T)*max(0, Path2(NSteps+1)-K);
   else
      payoff2 = 0;
      ncross = ncross+1;
   end

   LR1 = payoff1*score1;
   LR2 = payoff2*score2;
   
   LR(i) = (LR1+LR2)/2;
end


[vega, var, CI] = normfit(LR);