function [Vega, var, ncross, CI] = UOCallVegaLR(S0,K,r,T,sigma,Sb,NSteps,NRepl)

%Asset path generation 

Payoff = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
Path = zeros(1,1+NSteps);
ncross = 0;
score = zeros(NRepl,1);

for i=1:NRepl
    Path(1) = S0;
    for j=1:NSteps
        Z = randn;
        Path(j+1)=Path(j)*exp(nudt+sidt*Z);
        score(i) = score(i)+(Z^2-1)/sigma-Z*sqrt(dt);
    end
    crossed = any(Path >= Sb);
    if crossed == 0
        Payoff(i) = max(0, Path(NSteps+1)-K);
    else
        Payoff(i) = 0;
        ncross = ncross +1;
    end
end

dPayoff = exp(-r*T)*Payoff;
LRT = dPayoff.*score;

[Vega, var, CI] = normfit(LRT);