function [vega, var, CI] = UOCallVegaFDCN(S0,K,r,T,sigma,Sb,NSteps,NRepl,eps)

payoff1 = zeros(1,NRepl);
payoff2 = zeros(1,NRepl);
par = 'vega';

for i = 1:NRepl
    [Path1, Path2] =AssetPaths2(S0,r,sigma,T,NSteps,1, eps,par);
    if any(Path1>=Sb)
        payoff1(i) = 0;
    else
        payoff1(i) = max(0, Path1(NSteps+1) - K);     
    end

    if any(Path2>=Sb)
        payoff2(i) = 0;       
    else
        payoff2(i) = max(0, Path2(NSteps+1) - K);
    end
end

[vega, var, CI] = normfit(exp(-r*T)*(payoff1-payoff2)/(2*eps));
