function [rho, var, ncross, CI] = UOCallRhoLR(S0,K,r,T,sigma,Sb,NSteps,NRepl)

%Asset path generation 
Payoff = zeros(NRepl,1);
SPaths = zeros(1,1+NSteps);
dt = T/NSteps;
d = zeros(NRepl,NSteps);
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
ncross = 0;

for i=1:NRepl
    SPaths(1) = S0;
    for j=1:NSteps
        Z = randn;
        SPaths(j+1)=SPaths(j)*exp(nudt+sidt*Z);
        d(i,j) = (log(SPaths(j+1)/SPaths(j))-nudt)/sidt;
    end
    crossed = any(SPaths >= Sb);
    if crossed == 0
        Payoff(i) = max(0, SPaths(NSteps+1)-K);
    else
        Payoff(i) = 0;
        ncross = ncross +1;
    end
end

score = -T+sqrt(dt).*sum(d,2)./sigma;

dPayoff = exp(-r*T)*Payoff;

LR = dPayoff.*score;
[rho, var, CI] = normfit(LR);
