function [gamma, var, ncross, CI] = UOCallGammaLRAV(S0,K,r,T,sigma,Sb,NSteps,NRepl)

%Asset path generation saving Z1
LR = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);

Path1 = zeros(1,1+NSteps);
Path1(1) = S0;

Path2 = zeros(1,1+NSteps);
Path2(1) = S0;
ncross = 0;

for i=1:NRepl
   for j=1:NSteps
      Z1 = randn;
      Z2 = -Z1;
      Path1(j+1)=Path1(j)*exp(nudt+sidt*Z1);
      Path2(j+1)=Path2(j)*exp(nudt+sidt*Z2);
      if j == 1
          d1 = (log(Path1(j+1)/Path1(j))-nudt)/sidt;
          score1 = (d1.^2-d1.*sidt-1)./((S0*sidt)^2);
          d2 = (log(Path2(j+1)/Path2(j))-nudt)/sidt;
          score2 = (d2.^2-d2.*sidt-1)./((S0*sidt)^2);
      end
   end
   crossed1 = any(Path1 >= Sb);
   if crossed1 == 0
       payoff1 = exp(-r*T)*max(0, Path1(NSteps+1)-K);
   else
       payoff1 = 0;
       ncross = ncross+1;
   end
   crossed2 = any(Path2 >= Sb);
   if crossed2 == 0
       payoff2 = exp(-r*T)*max(0, Path2(NSteps+1)-K);
   else
      payoff2 = 0;
      ncross = ncross+1;
   end
   LR1 = payoff1*score1;
   LR2 = payoff2*score2;
   
   LR(i) = (LR1+LR2)/2;
end

[gamma, var, CI] = normfit(LR);