function [gamma, var, ncross, CI] = UOCallGammaLR(S0,K,r,T,sigma,Sb,NSteps,NRepl)

%Asset path generation saving Z1

Payoff = zeros(NRepl,1);
SPaths = zeros(1, 1+NSteps);
d1 = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
ncross = 0;

for i=1:NRepl
    SPaths(1) = S0;
    for j=1:NSteps
        Z = randn;
        SPaths(j+1)=SPaths(j)*exp(nudt+sidt*Z);
        if j == 1
            d1(i) = (log(SPaths(j+1)/SPaths(j))-nudt)/sidt;
        end
    end
    crossed = any(SPaths >= Sb);
    if crossed == 0
        Payoff(i) = max(0, SPaths(NSteps+1)-K);
    else
        Payoff(i) = 0;
        ncross = ncross +1;
    end
end


score = (d1.^2-d1.*sidt-1)./((S0*sidt)^2);
dPayoff = exp(-r*T)*Payoff;

LRT = dPayoff.*score;
[gamma, var, CI] = normfit(LRT);