function [gamma, var, CI] = UOCallGammaFDCN(S0,K,r,T,sigma,Sb,NSteps,NRepl,eps)
payoff1 = zeros(1,NRepl);
payoff2 = zeros(1,NRepl);
payoff3 = zeros(1,NRepl);

for i = 1:NRepl
    [Path1, Path2, Path3] = AssetPaths3(S0,r,sigma,T,NSteps,1, eps);
    if any(Path1>=Sb)
        payoff1(i) = 0;
    else
        payoff1(i) = max(0, Path1(NSteps+1) - K);
    end
    if any(Path2>=Sb)
        payoff2(i) = 0;
    else
        payoff2(i) = max(0, Path2(NSteps+1) - K);
    end
    if any(Path3>=Sb)
        payoff3(i) = 0;
    else
        payoff3(i) = max(0, Path3(NSteps+1) - K);
    end

end

[gamma, var, CI] = normfit(exp(-r*T)*(payoff1+payoff2-2*payoff3)/(eps^2));
