function [delta, var, ncross, CI] = UOCallDeltaLRAV(S0,K,r,T,sigma,Sb,NSteps,NRepl)

LR = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);

Path1 = zeros(1,1+NSteps);
Path1(1) = S0;

Path2 = zeros(1,1+NSteps);
Path2(1) = S0;


ncross = 0;
for i=1:NRepl
    for j=1:NSteps
        Z1 = randn;
        Z2 = -Z1;
        Path1(j+1)=Path1(j)*exp(nudt+sidt*Z1);
        Path2(j+1)=Path2(j)*exp(nudt+sidt*Z2);
        if j == 1
            score1 = Z1/(S0*sigma*sqrt(dt));
            score2 = Z2/(S0*sigma*sqrt(dt));
        end
    end
    crossed1 = any(Path1 >= Sb);
    if crossed1 == 0
      payoff1 = max(0, Path1(NSteps+1)-K);
   else
      payoff1 = 0;
      ncross = ncross+1;
    end
    crossed2 = any(Path2 >= Sb);
    if crossed2 == 0
      payoff2 = max(0, Path2(NSteps+1)-K);
    else
      payoff2 = 0;
      ncross = ncross+1;
    end
    LR1 = exp(-r*T)*payoff1*score1;
    LR2 = exp(-r*T)*payoff2*score2;
    
    LR(i) = (LR1+LR2)/2;

end


[delta, var, CI] = normfit(LR);