function [delta, var, ncross, CI] = UOCallDeltaLR(S0,K,r,T,sigma,Sb,NSteps,NRepl)

Payoff = zeros(NRepl,1);
Z1 = zeros(NRepl,1);
dt = T/NSteps;
nudt = (r-0.5*sigma^2)*dt;
sidt = sigma*sqrt(dt);
Path = zeros(1,1+NSteps);
ncross = 0;
for i=1:NRepl
    Path(1) = S0;
    for j=1:NSteps
        Z = randn;
        Path(j+1)=Path(j)*exp(nudt+sidt*Z);
        if j == 1
            Z1(i) = Z;
        end
    end
    crossed = any(Path >= Sb);
    if crossed == 0
      Payoff(i) = max(0, Path(NSteps+1)-K);
   else
      Payoff(i) = 0;
      ncross = ncross+1;
   end
end

score = Z1/(S0*sigma*sqrt(dt));
dPayoff = exp(-r*T)*Payoff;

[delta, var, CI] = normfit(dPayoff.*score);

