function  price = GeometricAsian(S0, K, T, r, sigma, numSamples)

dT = T/numSamples; 
nu = r-sigma^2/2;
a = log(S0)+nu*dT+0.5*nu*(T-dT);
b = sigma^2*dT+sigma^2*(T-dT)* (2*numSamples-1)/6/numSamples;
x = (a-log(K)+b)/sqrt(b);

price = exp(-r*T)*(exp(a+b/2)*normcdf(x)-K*normcdf(x-sqrt(b)));

end