function [price, var, CI] = EuropeanCallMC(S0,K,r,T,sigma,numRepl)

payoff = zeros(1,numRepl);
for i = 1:numRepl
    randNums = randn;
    ST = S0 * exp((r - 0.5 * sigma^2) * T + sigma * sqrt(T) * randNums);
    payoff(i) = max(ST - K, 0);   
end

discountedPayoff = exp(-r*T)*payoff;
[price, var, CI] = normfit(discountedPayoff);
