function [Vega, variance, CI] = CallVegaPath(S0,K,r,T,sigma,NRepl)

Z = randn(NRepl,1);
nuT = (r - 0.5*sigma^2)*T;
siT = sigma * sqrt(T);
ST = S0*exp(nuT+siT*Z);

d = (log(ST/S0)-(r+T*(sigma^2)/2))/(sigma);
SampleVega = exp(-r*T).*d.*ST.*(ST > K);

[Vega, variance, CI] = normfit(SampleVega);